@if(userCan('company-list')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif

@extends('layouts.default')
@php $pageTitle = 'Company List'; @endphp
@section('title',$pageTitle)
@section('PageHead')

@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
                  </button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  <section class="content">
@endif


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              @if(userCan('setting-list')>0)
              <li class="breadcrumb-item "><a href="/settings"> Settings </a></li>
              @endif
               @if(userCan('company-list')>0)
              <li class="breadcrumb-item "><a href="?"> {{$pageTitle}} </a></li>
              @endif
              @if(userCan('company-create')>0)
              <li class="breadcrumb-item active"><a href="/settings/company/create"> Add New</a></li>
              @endif
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

 @stop

@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <!-- /.card -->

            <div class="card">
              <!-- <div class="card-header">
                <h3 class="card-title">Employee List</h3>
              </div> -->
              <!-- /.card-header -->
              <form method="" action="" role="form" >
                {{ csrf_field() }} 
                <div class="card-header">
                Per Page
                  <select name="limit" class="">
                      <option value="10" > 10 </option>
                      <option value="25">25</option>
                      <option value="50">50</option>
                      <option value="100">100</option>
                  </select>
                <div class="card-tools">
                  <div class="input-group" style="width: auto">
                    <input type="text" name="searchin"
                      class="form-control form-control-sm float-right"
                      placeholder="Search">
                    <div class="input-group-append ">
                      <!-- <label>Satus</label> -->
                      <select name="searchfor"
                        class="custom-select custom-select-sm form-control form-control-sm">
                        <option value="">Search - All</option>
                        <option value="1" >Active</option>
                        <option value="0" >In-Active</option>
                      </select>
                    </div>

                    <div class="input-group-append">
                      <button type="submit" class="btn btn-default btn-sm">
                        <i class="fas fa-search"></i>
                      </button>
                    </div>
                  </div>
                </div>
              </div>
              </form>




              <div class="card-body table-responsive p-0 textCapital">
                <table class="table table-hover text-nowrap table-striped">
                  <thead>
                    <tr>
                      <th >Name </th>
                      <th>Company Type</th>
                      <th>Primary Contact Name</th>
                      <th >Primary Contact</th>
                      <th>Status</th>
                      <th>Action</th>
                    </tr>   
 
                  </thead>
                  <tbody>
                    @foreach($datas as $key=>$data)
                    <tr>
                      <td>
                        <!-- <span class="text-blue">{{$data->name}} </span> -->
                        {{$data->name}}<br>
                      <span class="text-blue">{{@$data->company_type_name->type_name}} </span>
                      </td>
                      <td>@if(intval($data->parent)>0) Parent @else Child @endif </td>
                      <td>{{$data->primary_contact_name}}<br>
                      <span class="text-blue">{{$data->primary_contact_designation}} </span></td>

                      <td>{{$data->email}}<br>
                      <span class="text-blue">{{$data->contact}} </span></td>
                      


                      <td>@if($data->status==1) Active @else Deactive @endif </td>
                      <td>
                        @if(userCan('company-edit')>0)
                        <a href="/settings/company/{{$data->id}}/edit"> <i class="fa fa-edit"></i></a>
                        @endif
                      </td>
                    </tr>
                  @endforeach
                  </tbody>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
       
        
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
 
@stop