@if(userCan('TrainingSchedule-create')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif
@extends('layouts.default')
@php $pageTitle = 'New Training Schedule '; @endphp
@section('title',$pageTitle)
@section('PageHead')

@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
                  </button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  <section class="content">
@endif


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              @if(userCan('setting-list')>0)
              <li class="breadcrumb-item "><a href="/settings"> Settings </a></li>
              @endif
              @if(userCan('TrainingSchedule-list')>0)
              <li class="breadcrumb-item "><a href="/settings/TrainingSchedule"> Training Schedule List </a></li>
              @endif
              @if(userCan('TrainingSchedule-create')>0)
              <li class="breadcrumb-item active"><a href="/settings/TrainingSchedule/create/"> Add New</a></li>
              @endif
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
@stop

@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <div class="card-body">
                <form method="POST" action="/settings/TrainingSchedule/store" role="form" id="">
                 {{ csrf_field() }}
                  <div class="row">

                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Training Name</label>
                        <select class="form-control" name="training_id" >
                          <option value="">Select One</option>
                          {!!TrainingName()!!}
                        </select>
                      </div>
                    </div>

                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Session Code</label>
                        <input type="text" class="form-control" name="session_code" placeholder="Enter..." value="{{old('session_code')}}" >
                      </div>
                    </div>

                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Type</label>
                        <select class="form-control" name="type" >
                          <option value="">Select One</option>
                          {!!TrainingScheduleType()!!}
                        </select>
                      </div>
                    </div>

                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Start Date</label>
                        <input type="Date" class="form-control" name="start_date" value="{{old('start_date')}}" >
                      </div>
                    </div>

                    <div class="col-md-3">
                      <div class="form-group">
                        <label>End Date</label>
                        <input type="Date" class="form-control" name="end_date" value="{{old('end_date')}}" >
                      </div>
                    </div>

                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Trainer</label>
                        <input type="text" class="form-control" name="trainer_name" value="{{old('trainer_name')}}" >
                      </div>
                    </div>

                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Training Organization</label>
                        <input type="text" class="form-control" name="training_organization" value="{{old('training_organization')}}" >
                      </div>
                    </div>

                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Location</label>
                        <textarea class="form-control" name="location" placeholder="Enter...">{{old('location')}}</textarea>
                      </div>
                    </div>

                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Cost</label>
                        <input type="text" class="form-control" name="cost" value="{{old('cost')}}" >
                      </div>
                    </div>

                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Max Enrol</label>
                        <input type="text" class="form-control" name="max_enroll" value="{{old('max_enroll')}}" >
                      </div>
                    </div>

                    

                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Status</label>
                        <select class="form-control" name="status">
                          
                          <option value=""> Select One </option>
                          <option value="1" @if(old('status')==1) selected @endif>Scheduled</option>
                          <option value="2" @if(old('status')==2) selected @endif>Re-Scheduled</option>
                          <option value="3" @if(old('status')==3) selected @endif>Cancel</option>  

                        </select>
                      </div>
                    </div>

                    </div>  
                  </div>



                
                <div class="col-md-12">
                  <br>
                  <div class="" align="right">
                    <button type="submit" class="btn btn-primary"> Save </button>
                  </div>
                </div>

               </div>
               <!-- /end row -->

                </form>
              </div>
              <!-- /.card-body -->
          </div>
          <!-- /.col -->
        </div>
       
        
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->




@stop