@if(userCan('SetKeyConfig-edit')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif
@extends('layouts.default')
@php $pageTitle = 'Update Key'; @endphp
@section('title',$pageTitle)
@section('PageHead')

@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
                  </button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  <section class="content">
@endif


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              @if(userCan('setting-list')>0)
              <li class="breadcrumb-item "><a href="/settings"> Settings </a></li>
              @endif
              @if(userCan('SetKeyConfig-list')>0)
              <li class="breadcrumb-item "><a href="/settings/SetKeyConfig"> Key List </a></li>
              @endif
              @if(userCan('SetKeyConfig-create')>0)
              <li class="breadcrumb-item active"><a href="/settings/SetKeyConfig/create/"> Add New</a></li>
              @endif
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
@stop

@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <div class="card-body">
                <form method="POST" action="/settings/SetKeyConfig/update" role="form" id="">
                 {{ csrf_field() }}
                 @method('PUT')
                 <input type="hidden" name="id" value="{{$data->id}}">
                 <input type="hidden" name="url" value="{{URL::previous()}}">
                  <div class="row">

                    <div class="col-sm-3">
                      <div class="form-group">
                        <label>Key Name</label>
                        <input type="text" class="form-control" name="key_name" placeholder="Enter..." value="{{@$data->key_name}}" >
                      </div>
                    </div>

                    <div class="col-sm-3">
                      <div class="form-group">
                        <label>Value</label>
                        <input type="text" class="form-control" name="value" placeholder="Enter..." value="{{@$data->value}}" >
                      </div>
                    </div>

                    <div class="col-sm-3">
                      <div class="form-group">
                        <label>Disc</label>
                        <input type="text" class="form-control" name="disc" placeholder="Enter..." value="{{@$data->disc}}" >
                      </div>
                    </div>

                    <div class="col-sm-3">
                      <div class="form-group">
                        <label>Notes</label>
                        <input type="text" class="form-control" name="sys_notes" placeholder="Enter..." value="{{@$data->sys_notes}}" >
                      </div>
                    </div>

                    <div class="col-md-2">
                      <div class="form-group">
                        <label>Status</label>
                        <select class="form-control" name="status" >
                          <option value="">Select One</option>
                          {!!statusIs(@$data->status)!!}
                        
                        </select>
                      </div>
                    </div>

                    </div>  
                  </div>
                    </div>    
                  </div>



                
                <div class="col-md-12">
                  <br>
                  <div class="" align="right">
                    <button type="submit" class="btn btn-primary"> Save </button>
                  </div>
                </div>

               </div>
               <!-- /end row -->

                </form>
              </div>
              <!-- /.card-body -->
          </div>
          <!-- /.col -->
        </div>
       
        
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->




@stop