@if(userCan('SetCostCenter-list')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif

@extends('layouts.default')
@php $pageTitle = 'Cost Center List'; @endphp
@section('title',$pageTitle)
@section('PageHead')

@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
    </button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  <section class="content">
@endif

@php
 $BankName= app('request')->input('bank_name');
 $SortName= app('request')->input('sort_name');
 $AccountN= app('request')->input('account_number');
 $CompanyId= app('request')->input('company_id');
 $appPerPage= app('request')->input('perPage');
@endphp

<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              @if(userCan('setting-list')>0)
              <li class="breadcrumb-item "><a href="/settings"> Settings </a></li>
              @endif
               @if(userCan('SetCostCenter-list')>0)
              <li class="breadcrumb-item "><a href="?"> {{$pageTitle}} </a></li>
              @endif
              @if(userCan('SetCostCenter-create')>0)
              <li class="breadcrumb-item active"><a href="/settings/CostCenter/create/"> Add New</a></li>
              @endif
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

<section class="content">
    <div class="container-fluid card">
        <form method="" action="" role="form" >
        <div class="row">

            
            <div class="col-md-3">
              Name
              <input type="" name="name" value="{{app('request')->input('name')}}" class="form-control" autocomplete="off" >
            </div>

            <div class="col-md-3">
              Parent Name
              <select class="form-control select2" name="parent_id" >
                <option value="">-</option>
                {!!@costcenter_list()!!}
              </select>
            </div>

            <div class="col-md-3">
              Status<br>
              <select name="status" id="status" class="form-control"  >
                <option value=""> All </option>
                {!! statusIs(app('request')->input('status')) !!}
              </select>
            </div>
            
            <div class="col-md-2">
              @php
                $perpage = ((app('request')->input('plimit'))>0) ? app('request')->input('plimit') : 50;
              @endphp
              Per Page<br>
              <select name="plimit" class="form-control">
                {!! PerPageForSelectOption($perpage) !!}
              </select>
            </div>

            
            <div class="col-md-1">
                <br>
              <button type="submit" class="btn btn-default btn-sm">
                <i class="fas fa-search"></i>
              </button>
            </div>
            
          
        </div>
        <!--// row-->
        </form>
        <br>
    </div>
    <!--// container-fluid-->

</section>
<!--// end section-->

 @stop

@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <!-- /.card -->

            <div class="card">
              <!-- <div class="card-header">
                <h3 class="card-title">Employee List</h3>
              </div> -->
              <!-- /.card-header -->

              <hr>

              <div class="card-body table-responsive p-0 textCapital">
                <table class="table table-hover  table-striped">
                  <thead>
                    <tr>
                      <th width="400">Name</th>
                      <th>Parent Name</th>
                      <th>Status</th>
                      <th>Action</th>
                    </tr>   
 
                  </thead>
                  <tbody>
                    @foreach($datas as $key=>$data)

                    <tr>
                      <td>
                        {{@$data->name}}
                      </td>

                      <td>
                        {{@$data->AccCostCenter->name}}
                      </td>

                      <td>
                        {{statusIs(@$data->status,1)}}
                      </td>

                      <td>
                        @if(userCan('SetCostCenter-edit')>0)
                        <a href="/settings/CostCenter/{{@$data->id}}/edit"> <i class="fa fa-edit"></i></a>
                        @endif
                      </td>
                    </tr>
                  @endforeach
                  </tbody>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
          
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->

@stop