@if(userCan('City-create')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif
@extends('layouts.default')
@php $pageTitle = 'Area Demarcation'; @endphp
@section('title',$pageTitle)
@section('PageHead')

@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
                  </button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  <section class="content">
@endif


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}<small style="color: blue;"></small></h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              @if(userCan('setting-list')>0)
              <li class="breadcrumb-item "><a href="/settings"> Settings </a></li>
              @endif
            </ol>
          </div><!-- /.col -->
          </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
@stop
<style>
  .nav-link{padding: .5rem 10px !important; }
  .nav-tabs .nav-link { border-right: 1px solid #bbb5b5 !important;}
</style>
@section('content')
    <!-- Main content -->

<section class="content">
  <div class="container-fluid">
    <div class="row">
      <!-- /.col -->
      <div class="col-md-12">
        <div class="card-body">

          <div class="row">
          <div class="col-12 col-sm-12">
            <div class="card card-primary card-tabs">
              <div class="card-header p-0 pt-1">
                <ul class="nav nav-tabs" id="custom-tabs-one-tab" role="tablist">
                  <li class="nav-item">
                    <a class="nav-link active" id="City-tab" data-toggle="pill" href="#City" role="tab" aria-controls="City" aria-selected="true">City Name</a>
                  </li>
                  <li class="nav-item">
                    <a class="nav-link" id="Zone-tab" data-toggle="pill" href="#Zone" role="tab" aria-controls="Zone" aria-selected="false">Zone Name</a>
                  </li>
                  <li class="nav-item">
                    <a class="nav-link" id="Area-tab" data-toggle="pill" href="#Area" role="tab" aria-controls="Area" aria-selected="false">Area Name</a>
                  </li>
                  
                </ul>
              </div>



              <div class="card-body">
                <div class="tab-content" id="City-tabs-one-tabContent">

                  <div class="tab-pane fade show active" id="City" role="tabpanel" aria-labelledby="City-tab">

                    <form method="POST" action="/settings/City/store" role="form" id="">
                    {{ csrf_field() }} 
                                        
                    <div class="row">

                        <div class="col-md-12">
                          
                      
                            <div class="panel panel-footer">

                              <div class="row">

                                
                                <div class="col-md-4">
                                  <div class="form-group">
                                    <label>City Name</label>
                                    <input type="text" class="form-control" name="name" placeholder="Enter..." value="{{old('name')}}" >
                                  </div>
                                </div>   


                                <div class="col-sm-4">
                                  <div class="form-group">
                                    <label>Status</label>
                                    <select class="form-control contact_status_action" name="status" >
                                      <option value="">Select One</option>
                                      <option selected value="1">Active</option>
                                      <option value="0">Deactive</option>
                                    </select>
                                  </div>
                                </div>

                           
                            </div>

                                 
                              
                            </div>
                            <!--/.col (left) -->
                            
                          </div>
                    </div>  

                    <div class="" align="right">
                      <button type="submit" class="btn btn-primary"> Save </button>
                    </div>              
                    </form>


                    <div class="container-fluid">
                      @php
                       $CityName= app('request')->input('cityName');
                       $appPerPage= app('request')->input('perPage');
                      @endphp
                      <div class="row">
                        <!-- /.col -->
                        <div class="col-md-12">
                          <!-- /.card -->
                          <div class="col-md-6 row"> <h4> City Name List </h4> </div>

                          <form method="get" action="" role="form" >
                
                            <div class="card-header">

                            Per Page
                              @php  $curentperPagesnum = isset($_GET['perPage'])?$_GET['perPage']:10; @endphp
                              @php  $perPages = array(10,15,20,50,100,500,1000);@endphp
                              <select name="perPage" id="perPage" onchange="this.form.submit()">
                                <option value="{{@$appPerPage}}">Select All</option>
                                @foreach( $perPages as $key =>$perPagesnum )
                                <option @if($curentperPagesnum == $perPagesnum) selected="selected" @endif value="{{$perPagesnum}}">{{$perPagesnum}}</option>
                                @endforeach
                              </select>
                 

                            <div class="card-tools">
                              <div class="input-group" style="width: auto">

                                    <input type="text" class="form-control" name="cityName" placeholder="City Name" value="{{@$CityName}}">&emsp;

                                <div class="input-group-append">
                                  <button type="submit" class="btn btn-default btn-sm" onchange="this.form.submit()">
                                    <i class="fas fa-search"></i>
                                  </button>
                                </div>
                              </div>
                            </div>
                          </div>
                          </form>

                          <div class="col-md-12" >
                            {{paginationHeaderInfo($data_city)}}
                              <div class="col-md-12 pagination-area" >
                                {{$data_city->appends([              
                                    'cityName' => $CityName,
                                    'perPage' => $appPerPage  
                                ])->links('pagination::bootstrap-4')}}
                              </div>
                          </div>

                          <div class="card">

                            <div class="card-body table-responsive p-0">
                              <table class="table table-hover  table-striped">
                                <thead>
                                  <tr>
                                    <th>City Name</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                  </tr>   
               
                                </thead>
                                <tbody>
                                @foreach($data_city as $key=>$data)   
                                               
                                  <tr>
                                    
                                    <td>{{@$data->name}}</td>
                                    <td>@if((@$data->status)==1) Active @else Deactive @endif</td>
                                    <td>
                                      <button type="button" class="btn btn-default" data-toggle="modal" data-target="#modal-city-{{$key}}">
                                      <i class="fa fa-edit fa-1x"></i>
                                      </button>
                                    </td>
                                  </tr>

                                          <!-- model for update info -->
                                  <div class="modal fade" id="modal-city-{{$key}}">
                                    <form role="form" method="POST" action="/settings/City/update" >
                                    {{ csrf_field() }}
                                     {{ method_field('PUT') }}
                                     <input type="hidden" name="id" value="{{$data->id}}">
                                     <input type="hidden" name="url" value="{{URL::previous()}}">
                                    

                                    <div class="modal-dialog">
                                      <div class="modal-content">
                                        <div class="modal-header">
                                          <h4 class="modal-title">Update - {{@$data->name}}</h4>
                                          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                          </button>
                                        </div>
                                        <div class="modal-body">
                                          <!-- <p>Update Payment History &hellip;</p> -->

                                          <div class="row">

                                
                                            <div class="col-md-6">
                                              <div class="form-group">
                                                <label>City Name</label>
                                                <input type="text" class="form-control" name="name" placeholder="Enter..." value="{{@$data->name}}" >
                                              </div>
                                            </div>   

                                            <div class="col-sm-6">
                                              <div class="form-group">
                                                <label>Status</label>
                                                <select class="form-control " name="status" >
                                                  <option value="">Select One</option>
                                                  <option value="1" {{ (@$data->status=="1")? "selected" : "" }}>Active</option>
                                                  <option value="0" {{ (@$data->status=="0")? "selected" : "" }}>Deactive</option>
                                                </select>
                                              </div>
                                            </div> 
                                       
                                        </div>

                                        </div>
                                        <div class="modal-footer justify-content-between">
                                          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                          <button type="submit" class="btn btn-primary">Save changes</button>
                                        </div>
                                      </div>
                                      <!-- /.modal-content -->
                                    </div>

                                    </form>
                                    <!-- /.modal-dialog -->
                                  </div>
                                  <!-- /.modal -->
                                  
                              @endforeach
                            </tbody>
                              </table>
                            </div>
                            <!-- /.card-body -->
                          </div>
                          <!-- /.card -->

                          <div class="col-md-12" >
                            {{paginationHeaderInfo($data_city)}}
                              <div class="col-md-12 pagination-area" >
                                {{$data_city->appends([              
                                    'cityName' => $CityName,
                                    'perPage' => $appPerPage  
                                ])->links('pagination::bootstrap-4')}}
                              </div>
                          </div>



                        </div>
                        <!-- /.col -->
                      </div>
                     
                      
                    </div><!-- /.container-fluid -->


                  </div>
                  <!-- end panel City Details -->






                  <div class="tab-pane fade" id="Zone" role="tabpanel" aria-labelledby="Zone-tab">

                    <form role="form" method="POST" action="/settings/Zone/store">
                    {{ csrf_field() }} 

                    <div class="row">

                        <div class="col-md-12">
                                                
                            <div class="panel panel-footer">

                              <div class="row">

                                
                                <div class="col-md-4">
                                  <div class="form-group">
                                    <label>Zone Name</label>
                                    <input type="text" class="form-control" name="name" placeholder="Enter..." value="{{old('name')}}" >
                                  </div>
                                </div>

                                <div class="col-sm-4">
                                  <div class="form-group">
                                    <label>City Name</label>
                                    <select class="form-control" name="city_id" >
                                      <option value="">Select One</option>
                                      {!!city_list()!!}
                                    </select>
                                  </div>
                                </div>     

                                <div class="col-sm-4">
                                  <div class="form-group">
                                    <label>Status</label>
                                    <select class="form-control" name="status" >
                                      <option value="">Select One</option>
                                      <option selected value="1">Active</option>
                                      <option value="0">Deactive</option>
                                    </select>
                                  </div>
                                </div>

                           
                            </div>
     
                              
                            </div>
                            <!--/.col (left) -->
                            
                          </div>
                    </div>  

                    <div class="" align="right">
                      <button type="submit" class="btn btn-primary"> Save </button>
                    </div>              
                    </form>

                    

                    <div class="container-fluid">
                      @php
                       $CityId= app('request')->input('city_id');
                       $ZoneName= app('request')->input('zoneName');
                       $appPerPage1= app('request')->input('perPage1');
                      @endphp
                      <div class="row">
                        <!-- /.col -->
                        <div class="col-md-12">
                          <!-- /.card -->
                          <div class="col-md-6 row"> <h4> Zone Name List </h4> </div>

                          <form method="get" action="" role="form" >
                
                            <div class="card-header">

                            Per Page
                              @php  $curentperPagesnum = isset($_GET['perPage1'])?$_GET['perPage1']:10; @endphp
                              @php  $perPages = array(1,15,20,50,100,500,1000);@endphp
                              <select name="perPage1" id="perPage1" onchange="this.form.submit()">
                                <option value="{{@$appPerPage1}}">Select All</option>
                                @foreach( $perPages as $key =>$perPagesnum )
                                <option @if($curentperPagesnum == $perPagesnum) selected="selected" @endif value="{{$perPagesnum}}">{{$perPagesnum}}</option>
                                @endforeach
                              </select>
                 

                            <div class="card-tools">
                              <div class="input-group" style="width: auto">

                                    <select class="form-control" name="city_id" onchange="this.form.submit()">
                                      <option value="">City Name</option>
                                      {!!city_list()!!}
                                    </select>&emsp;

                                    <input type="text" class="form-control" name="zoneName" placeholder="Zone Name" value="{{@$ZoneName}}">&emsp;

                                <div class="input-group-append">
                                  <button type="submit" class="btn btn-default btn-sm" onchange="this.form.submit()">
                                    <i class="fas fa-search"></i>
                                  </button>
                                </div>
                              </div>
                            </div>
                          </div>
                          </form>

                          <div class="col-md-12" >
                            {{paginationHeaderInfo($data_zone)}}
                              <div class="col-md-12 pagination-area" >
                                {{$data_zone->appends([              
                                    'city_id' => $CityId,
                                    'zoneName' => $ZoneName,
                                    'perPage1' => $appPerPage1  
                                ])->links('pagination::bootstrap-4')}}
                              </div>
                          </div>

                          <div class="card">

                            <div class="card-body table-responsive p-0">
                              <table class="table table-hover  table-striped">
                                <thead>
                                  <tr>
                                    <th>Zone Name</th>
                                    <th>City Name</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                  </tr>   
               
                                </thead>
                                <tbody>   
                                  @foreach($data_zone as $key=>$data)          
                                  <tr>
                                    
                                    
                                    <td>{{@$data->name}}</td>
                                    <td>{{@$data->city_name->name}}</td>
                                    <td>@if((@$data->status)==1) Active @else Deactive @endif</td>                                   
                                    <td>
                                      <button type="button" class="btn btn-default" data-toggle="modal" data-target="#modal-Zone-{{$key}}">
                                      <i class="fa fa-edit fa-1x"></i>
                                      </button>
                                    </td>
                                  </tr>

                                          <!-- model for update info -->
                                  <div class="modal fade" id="modal-Zone-{{$key}}">
                                    <form role="form" method="POST" action="/settings/Zone/update" >
                                    {{ csrf_field() }}
                                     {{ method_field('PUT') }}
                                     <input type="hidden" name="id" value="{{$data->id}}">
                                     <input type="hidden" name="url" value="{{URL::previous()}}">

                                    <div class="modal-dialog">
                                      <div class="modal-content">
                                        <div class="modal-header">
                                          <h4 class="modal-title">Update - {{@$data->name}}</h4>
                                          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                          </button>
                                        </div>
                                        <div class="modal-body">
                                          

                                          <div class="row">

                                
                                            <div class="col-md-6">
                                              <div class="form-group">
                                                <label>Zone Name</label>
                                                <input type="text" class="form-control" name="name" placeholder="Enter..." value="{{@$data->name}}" >
                                              </div>
                                            </div>

                                            <div class="col-sm-6">
                                              <div class="form-group">
                                                <label>City Name</label>
                                                <select class="form-control" name="city_id" >
                                                  <option value="">Select One</option>
                                                  {!!city_list(@$data->city_id)!!}
                                                </select>
                                              </div>
                                            </div>   

                                            <div class="col-sm-6">
                                              <div class="form-group">
                                                <label>Status</label>
                                                <select class="form-control " name="status" >
                                                  <option value="">Select One</option>
                                                  <option value="1" {{ (@$data->status=="1")? "selected" : "" }}>Active</option>
                                                  <option value="0" {{ (@$data->status=="0")? "selected" : "" }}>Deactive</option>
                                                </select>
                                              </div>
                                            </div>

                                       
                                        </div>

                                        </div>
                                        <div class="modal-footer justify-content-between">
                                          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                          <button type="submit" class="btn btn-primary">Save changes</button>
                                        </div>
                                      </div>
                                      <!-- /.modal-content -->
                                    </div>

                                    </form>
                                    <!-- /.modal-dialog -->
                                  </div>
                                  <!-- /.modal -->
                                  
                             @endforeach 
                            </tbody>
                              </table>
                            </div>
                            <!-- /.card-body -->
                          </div>
                          <!-- /.card -->

                          <div class="col-md-12" >
                            {{paginationHeaderInfo($data_zone)}}
                              <div class="col-md-12 pagination-area" >
                                {{$data_zone->appends([              
                                    'city_id' => $CityId,
                                    'zoneName' => $ZoneName,
                                    'perPage1' => $appPerPage1  
                                ])->links('pagination::bootstrap-4')}}
                              </div>
                          </div>



                        </div>
                        <!-- /.col -->
                      </div>
                     
                      
                    </div><!-- /.container-fluid -->

                  </div>
                  <!-- end panel Zone-->






                  <div class="tab-pane fade" id="Area" role="tabpanel" aria-labelledby="Area-tab">
                    <form role="form" method="POST" action="/settings/Area/store">
                    {{ csrf_field() }}                
                    
                    <div class="row">

                        <div class="col-md-12">
                          

                      
                            <div class="panel panel-footer">

                              <div class="row">

                                
                                <div class="col-md-4">
                                  <div class="form-group">
                                    <label>Area Name</label>
                                    <input type="text" class="form-control" name="name" placeholder="Enter..." value="{{old('name')}}" >
                                  </div>
                                </div>

                                <div class="col-sm-4">
                                  <div class="form-group">
                                    <label>Zone Name</label>
                                    <select class="form-control" name="zone_id" >
                                      <option value="">Select One</option>
                                      {!!zone_list()!!}
                                    </select>
                                  </div>
                                </div>   

                                <div class="col-sm-4">
                                  <div class="form-group">
                                    <label>Status</label>
                                    <select class="form-control" name="status" >
                                      <option value="">Select One</option>
                                      <option selected value="1">Active</option>
                                      <option value="0">Deactive</option>
                                    </select>
                                  </div>
                                </div>

                           
                            </div>

                              
                            </div>
                            <!--/.col (left) -->
                            
                          </div>
                    </div>  

                    <div class="" align="right">
                      <button type="submit" class="btn btn-primary"> Save </button>
                    </div>              
                    </form>

                    <div class="container-fluid">
                      <div class="row">
                        <!-- /.col -->
                        <div class="col-md-12">
                          <!-- /.card -->
                          <div class="col-md-6 row"> <h4> Area Name List </h4> </div>

                          <hr>

                          <div class="card">

                            <div class="card-body table-responsive p-0">
                              <table class="table table-hover  table-striped">
                                <thead>
                                  <tr>
                                    
                                    <th>Area Name</th>
                                    <th>Zone Name</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                  </tr>   
               
                                </thead>
                                <tbody>   
                                  @foreach($data_area as $key=>$data)         
                                  <tr>
                                    
                                    <td>{{@$data->name}}</td>
                                    <td>{{@$data->zone_name->name}}</td>
                                    <td>@if((@$data->status)==1) Active @else Deactive @endif</td>
                                    <td>
                                      <button type="button" class="btn btn-default" data-toggle="modal" data-target="#modal-Area-{{$key}}">
                                      <i class="fa fa-edit fa-1x"></i>
                                      </button>
                                    </td>
                                  </tr>

                                          <!-- model for update info -->
                                  <div class="modal fade" id="modal-Area-{{$key}}">
                                    <form role="form" method="POST" action="/settings/Area/update" >
                                    {{ csrf_field() }}
                                     {{ method_field('PUT') }}
                                     <input type="hidden" name="id" value="{{$data->id}}">
                                     <input type="hidden" name="url" value="{{URL::previous()}}">

                                    <div class="modal-dialog">
                                      <div class="modal-content">
                                        <div class="modal-header">
                                          <h4 class="modal-title">Update - {{@$data->name}}</h4>
                                          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                          </button>
                                        </div>
                                        <div class="modal-body">
                                          <!-- <p>Update Payment History &hellip;</p> -->

                                          <div class="row">

                                
                                            <div class="col-md-6">
                                              <div class="form-group">
                                                <label>Area Name</label>
                                                <input type="text" class="form-control" name="name" placeholder="Enter..." value="{{@$data->name}}" >
                                              </div>
                                            </div>

                                            <div class="col-sm-6">
                                              <div class="form-group">
                                                <label>Zone Name</label>
                                                <select class="form-control" name="zone_id" >
                                                  <option value="">Select One</option>
                                                  {!!zone_list(@$data->zone_id)!!}
                                                </select>
                                              </div>
                                            </div>   

                                            <div class="col-sm-6">
                                              <div class="form-group">
                                                <label>Status</label>
                                                <select class="form-control " name="status" >
                                                  <option value="">Select One</option>
                                                  <option value="1" {{ (@$data->status=="1")? "selected" : "" }}>Active</option>
                                                  <option value="0" {{ (@$data->status=="0")? "selected" : "" }}>Deactive</option>
                                                </select>
                                              </div>
                                            </div>
                                       
                                        </div>

                                        </div>
                                        <div class="modal-footer justify-content-between">
                                          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                          <button type="submit" class="btn btn-primary">Save changes</button>
                                        </div>
                                      </div>
                                      <!-- /.modal-content -->
                                    </div>

                                    </form>
                                    <!-- /.modal-dialog -->
                                  </div>
                                  <!-- /.modal -->
                                  
                              @endforeach
                            </tbody>
                              </table>
                            </div>
                            <!-- /.card-body -->
                          </div>
                          <!-- /.card -->
                        </div>
                        <!-- /.col -->
                      </div>
                     
                      
                    </div><!-- /.container-fluid -->

                  </div>
                  <!-- end panel Payment-->



                  <!-- ***************************************************** -->











           

                </div>
              </div>
              <!-- /.card -->
            </div>
          </div>
        </div>
        <!-- row -->


        </div>
      </div>
    </div>
  </div>
</section>





@stop