@if(userCan('ChartOfAccounts-create')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif
@extends('layouts.default')
@php $pageTitle = 'Chart of Accounts'; @endphp
@section('title',$pageTitle)
@section('PageHead')

@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
    </button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  <section class="content">
@endif


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-md-5">
            <h3 class="card-title">{{$pageTitle}}<small style="color: blue;"></small></h3>
          </div><!-- /.col -->
          <div class="col-md-7">
            <ol class="breadcrumb float-md-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              @if(userCan('setting-list')>0)
              <li class="breadcrumb-item "><a href="/settings"> Settings </a></li>
              @endif
            </ol>
          </div><!-- /.col -->
          </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
@stop
<style>
  .nav-link{padding: .5rem 12px !important; }
  .nav-tabs .nav-link { border-right: 1px solid #bbb5b5 !important;}
</style>
@section('content')
    <!-- Main content -->

@php

$defult = ''; $active_tab = 'show active';

$Accounts =  $defult;
$Accounts_details = $defult;
$Accounts_type = $defult;

  
  $tablink = app('request')->input('tab');

  if($tablink=='accounts'){
    $Accounts = $active_tab;
  }else if($tablink=='accounts_details'){
    $Accounts_details = $active_tab;
  }else if($tablink=='accounts_type'){
    $Accounts_type = $active_tab;
  }else{
    $Accounts = $active_tab;
  }

@endphp
<!-- end check current tab -->

<section class="content">
  <div class="container-fluid">
    <div class="row">
      <!-- /.col -->
      <div class="col-md-12">
        <div class="card-body">

          <div class="row">
          <div class="col-12 col-md-12">
            <div class="card card-primary card-tabs">
              <div class="card-header p-0 pt-1">
                <ul class="nav nav-tabs" id="custom-tabs-one-tab" role="tablist">
                  <li class="nav-item">
                    <a class="nav-link {{$Accounts}}" id="ChartOfAccounts-tab" data-toggle="pill" href="#ChartOfAccounts" role="tab" aria-controls="ChartOfAccounts" aria-selected="true">Chart of Accounts</a>
                  </li>
                  <li class="nav-item">
                    <a class="nav-link {{$Accounts_details}}" id="AccountDetailsType-tab" data-toggle="pill" href="#AccountDetailsType" role="tab" aria-controls="AccountDetailsType" aria-selected="false">Account Details Type</a>
                  </li>
                  <li class="nav-item">
                    <a class="nav-link {{$Accounts_type}}" id="AccountType-tab" data-toggle="pill" href="#AccountType" role="tab" aria-controls="AccountType" aria-selected="false">Account Type</a>
                  </li>
                  
                </ul>
              </div>



              <div class="card-body">
                <div class="tab-content" id="ChartOfAccounts-tabs-one-tabContent">

                  <div class="tab-pane fade {{$Accounts}}" id="ChartOfAccounts" role="tabpanel" aria-labelledby="ChartOfAccounts-tab">

                    
                    <div class="container-fluid">
                      <div class="row">
                        <!-- /.col -->
                        <div class="col-md-12">
                          <!-- /.card -->

                          <div class="col-md-12" align="right"><button type="button" class="btn btn-primary"data-toggle="modal" data-target="#modal-Accounts">Add New
                           </button></div>

                          <div class="card">

                            <div class="card-body table-responsive p-0">
                              <table class="table table-hover  table-striped">
                                <thead>
                                  <tr>
                                    <th>Code</th>
                                    <th>Name</th>
                                    <th>Details Type</th>
                                    <th>Account Type</th>
                                    <th width="100">Debit</th>
                                    <th width="100">Cradit</th>
                                    <th width="110">Balance</th>
                                    <th width="120">Action</th>
                                  </tr>   
               
                                </thead>
                                <tbody>
                                @php $balance_total = $balance = 0; @endphp                                   
                                @foreach($data_AccountName as $key=>$data)   
                                   @php 
                                    $balance = 0; $lable= '';
                                    if($data->sense==1){ $lable = ' Dr'; @$balance = $data->DrTotalByAccID->total - $data->CrTotalByAccID->total; 
                                    $balance += $data->account_opening_balance; 
                                    $balance_total += $balance; }
                                    elseif($data->sense==2){ $lable = ' Cr'; @$balance = $data->CrTotalByAccID->total - $data->DrTotalByAccID->total;$balance += $data->account_opening_balance;  $balance_total += $balance; }
                                   @endphp
                                  <tr>
                                    
                                    <td title="{{$data->account_Name_id}}">{{@$data->account_number}}</td>
                                    <td>{{@$data->account_name}}</td>
                                    <td>{{@$data->account_details_informations->detail_type_name}}</td>
                                    <td>{{@$data->account_type_informations->account_type_name}}</td>
                                    <td align="right">@if($data->sense==1 && $data->account_opening_balance>0) {{@number_format($data->DrTotalByAccID->total+$data->account_opening_balance,2)}} @else {{@number_format($data->DrTotalByAccID->total,2)}} @endif </td>
                                    <td align="right">@if($data->sense==2 && $data->account_opening_balance>0) {{number_format(@$data->CrTotalByAccID->total+$data->account_opening_balance,2)}} @else {{number_format(@$data->CrTotalByAccID->total,2)}} @endif </td>
                                    <td align="right" title="open:{{$data->account_opening_balance}}">{{number_format($balance,2)}} {{$lable}}</td>
                                    <td title="{{$data->account_Name_id}}">
                                      <button type="button" class="btn btn-default" data-toggle="modal" data-target="#modal-ChartOfAccounts-{{$key}}">
                                      <i class="fa fa-edit fa-1x"></i>
                                      </button>

                                      <a href="/report/ChartOfAccount/RunReport/{{$data->account_Name_id}}/find?"><i class="fa fa-file"></i> 
                                    </td>
                                  </tr>

                                          <!-- model for update info -->
                                  <div class="modal fade" id="modal-ChartOfAccounts-{{$key}}">
                                    <form role="form" method="POST" action="/settings/ChartOfAccounts/update" >

                                      <input type="hidden" name="url" value="{{URL::current()}}">
                                      <input type="hidden" name="tab" value="accounts">
                                                                       
                                    <div class="modal-dialog modal-lg">
                                      <div class="modal-content">
                                        <div class="modal-header">
                                          <h4 class="modal-title">Update - {{@$data->account_number}}</h4>
                                          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                          </button>
                                        </div>
                                        <div class="modal-body">
                                          <!-- <p>Update Payment History &hellip;</p> -->

                                         {{ csrf_field() }}
                                         {{ method_field('PUT') }}
                                         <input type="hidden" name="id" value="{{$data->account_Name_id}}">
                                         <input type="hidden" name="url" value="{{URL::current()}}">

                                          <div class="row">

                                          <div class="col-md-4">
                                            <div class="form-group">
                                              <label>Account Type *</label>
                                              <select class="form-control" name="account_type_id" required>
                                                <option value="">Select One</option>
                                                {!!account_type_list(@$data->account_type_id)!!}
                                              </select>
                                            </div>
                                          </div>

                                          <div class="col-md-4">
                                            <div class="form-group">
                                              <label>Account Details Type *</label>
                                              <select class="form-control" name="detail_type_id" required>
                                                <option value="">Select One</option>
                                                {!!account_details_type(@$data->detail_type_id)!!}
                                                
                                              </select>
                                            </div>
                                          </div>

                                          
                                          <div class="col-md-4">
                                            <div class="form-group">
                                              <label>Root Code</label>
                                              <input type="text" class="form-control" value="{{@$data->account_details_informations->dcode}}" readonly>
                                            </div>
                                          </div>

@php     
  if(intval(@$data->account_number)>0){
    $code = @$data->account_number;
    $root_code = @$data->account_details_informations->dcode;

    $final_code = substr($code, strlen($root_code));
                                      
  }
@endphp

                                          <div class="col-md-4">
                                            <div class="form-group">
                                              <label>Code/Account Number *</label>
                                              <input type="text" class="form-control" name="account_number" placeholder="Enter..." value="{{@$final_code}}" required>
                                            </div>
                                          </div>

                                          <div class="col-md-4">
                                            <div class="form-group">
                                              <label>Account Name *</label>
                                              <input type="text" class="form-control" name="account_name" placeholder="Enter..." value="{{@$data->account_name}}" required>
                                            </div>
                                          </div>

                                          <div class="col-md-4">
                                            <div class="form-group">
                                              <label>Opening Balance</label>
                                              <input type="text" class="form-control" name="account_opening_balance" placeholder="Enter..." value="{{@$data->account_opening_balance}}">
                                            </div>
                                          </div>

                                          <div class="col-md-4">
                                            <label>As of Date</label>
                                            <div class="input-group " >
                                              <input type="date" name="as_of_opening_balance" value="{{@$data->as_of_opening_balance}}" class="form-control">
                                            </div>
                                          </div>

                                          <div class="col-md-4">
                                            <div class="form-group">
                                              <label>Company Name *</label>
                                              <select class="form-control" name="app_company_id" required>
                                                <option value="">Select One</option>
                                                {!!company_list(@$data->app_company_id)!!}
                                              </select>
                                            </div>
                                          </div>

                                          <div class="col-md-4">
                                            <div class="form-group">
                                              <label>Branch Name *</label>
                                              <select class="form-control" name="app_branch_id"  required>
                                                <option value="">Select One</option>
                                                {!!branchList(@$data->app_branch_id)!!}
                                              </select>
                                            </div>
                                          </div>

                                          <div class="col-md-8">
                                            <div class="form-group">
                                              <label>Description</label>
                                              <textarea class="form-control" name="account_description" placeholder="Enter...">{{@$data->account_description}}</textarea>
                                            </div>
                                          </div>

                                          <div class="col-md-3">
                                            <div class="form-group">
                                              <label>Sense *</label>
                                              <select class="form-control" name="sense" required>
                                                <option value=""> Select </option>
                                                <option @if(@$data->sense==1) selected @endif value="1"> Dr </option>
                                                <option @if(@$data->sense==2) selected @endif value="2"> Cr </option> 
                                              </select>
                                            </div>
                                          </div>                              
                                                                                   
                                          </div>

                                        </div>
                                        <div class="modal-footer justify-content-between">
                                          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                          <button type="submit" class="btn btn-primary">Save changes</button>
                                        </div>
                                      </div>
                                      <!-- /.modal-content -->
                                    </div>

                                    </form>
                                    <!-- /.modal-dialog -->
                                  </div>
                                  <!-- /.modal -->
                                  
                              @endforeach
                            </tbody>
                              </table>
                            </div>
                            <!-- /.card-body -->
                          </div>
                          <!-- /.card -->
                        </div>
                        <!-- /.col -->
                      </div>
                     
                      
                    </div><!-- /.container-fluid -->



                    <div class="modal fade" id="modal-Accounts">
                      <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                          <div class="modal-header">
                            <h4 class="modal-title">Chart of Accounts</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                            </button>
                          </div>

                          <div class="modal-body">

                            <form method="POST" action="/settings/ChartOfAccounts/store" role="form" id="">
                            {{ csrf_field() }} 

                            <input type="hidden" name="url" value="{{URL::current()}}">
                            <input type="hidden" name="tab" value="accounts">
                                                
                            <div class="row">

                                <div class="col-md-12">
                                  
                              
                                    <div class="panel panel-footer">

                                      <div class="row">

                                        <div class="col-md-3">
                                          <div class="form-group">
                                            <label>Account Type</label>
                                            <select class="form-control account_type" name="account_type_id" required>
                                              <option value="">Select One</option>
                                              {!!account_type_list()!!}
                                            </select>
                                          </div>
                                        </div>

                                        <div class="col-md-3">
                                          <div class="form-group">
                                            <label>Account Details Type</label>
                                            <select class="form-control account_details" name="detail_type_id" required>
                                              <option value=""> - </option>
                                              <!-- {!!account_details_type()!!} -->
                                              
                                            </select>
                                          </div>
                                        </div>

                                        
                                        <div class="col-md-3">
                                          <div class="form-group">
                                            <label>Code</label>
                                            <input type="text" class="form-control" readonly>
                                          </div>
                                        </div>

                                        <div class="col-md-3">
                                          <div class="form-group">
                                            <label>Account Number *</label>
                                            <input type="text" class="form-control" name="account_number" placeholder="Enter..." value="{{old('account_number')}}" required>
                                          </div>
                                        </div>

                                        <div class="col-md-6">
                                          <div class="form-group">
                                            <label>Account Name *</label>
                                            <input type="text" class="form-control" name="account_name" placeholder="Enter..." value="{{old('account_name')}}" required>
                                          </div>
                                        </div>

                                        <div class="col-md-3">
                                          <div class="form-group">
                                            <label>Opening Balance</label>
                                            <input type="text" class="form-control" name="account_opening_balance" placeholder="Enter..." value="{{old('account_opening_balance')}}">
                                          </div>
                                        </div>

                                        <div class="col-md-3">
                                          <label>As of Date</label>
                                          <div class="input-group " >
                                            <input type="date" name="as_of_opening_balance" value="{{old('as_of_opening_balance')}}" class="form-control">
                                          </div>
                                        </div>

                                        <div class="col-md-6">
                                          <div class="form-group">
                                            <label>Description</label>
                                            <textarea class="form-control" name="account_description" placeholder="Enter..."></textarea>
                                          </div>
                                        </div> 

                                        <div class="col-md-3">
                                          <div class="form-group">
                                            <label>Company Name *</label>
                                            <select class="form-control company_name" name="app_company_id" required>
                                              <option value="">Select One</option>
                                              {!!company_list()!!}
                                            </select>
                                          </div>
                                        </div>

                                        <div class="col-md-3">
                                          <div class="form-group">
                                            <label>Branch Name *</label>
                                            <select class="form-control branch_name" name="app_branch_id">
                                              <option value=""> - </option>
                                              <!-- {!!branchList()!!} -->
                                            </select>
                                          </div>
                                        </div>

                                        <div class="col-md-3">
                                          <div class="form-group">
                                            <label>Sense *</label>
                                            <select class="form-control" name="sense" required>
                                              <option value=""> Select </option>
                                              <option value="1"> Dr </option>
                                              <option value="2"> Cr </option>
                                              
                                            </select>
                                          </div>
                                        </div>


                                                                           

                                    </div>

                                         
                                      
                                    </div>
                                    <!--/.col (left) -->
                                    
                                  </div>
                            </div>  

                            <div class="" align="right">
                              <button type="submit" class="btn btn-primary"> Save </button>
                            </div>              
                            </form>

                          </div>
                        </div>
                        <!-- /.modal-content -->
                      </div>
                      <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->


                  </div>
                  <!-- end panel City Details -->






                  <div class="tab-pane fade {{$Accounts_details}}" id="AccountDetailsType" role="tabpanel" aria-labelledby="AccountDetailsType-tab">
                   

                    <div class="container-fluid">
                      <div class="row">
                        <!-- /.col -->
                        <div class="col-md-12">
                          <!-- /.card -->

                          <div class="col-md-12" align="right"><button type="button" class="btn btn-primary"data-toggle="modal" data-target="#modal-AccountDetails">Add New
                           </button></div>
                          

                          <div class="card">

                            <div class="card-body table-responsive p-0">
                              <table class="table table-hover  table-striped">
                                <thead>
                                  <tr>
                                    <th>Code</th>
                                    <th>Details Type</th>
                                    <th>Account Type</th>
                                    <th>Action</th>
                                  </tr>   
               
                                </thead>
                                <tbody>   
                                  @foreach($data_AccountDetails as $key=>$data)          
                                  <tr>
                                    
                                    
                                    <td>{{@$data->dcode}}</td>
                                    <td>{{@$data->detail_type_name}}</td>
                                    <td>{{@$data->account_type->account_type_name}}</td>                                   
                                    <td>
                                      <button type="button" class="btn btn-default" data-toggle="modal" data-target="#modal-AccountDetailsType-{{$key}}">
                                      <i class="fa fa-edit fa-1x"></i>
                                      </button>
                                    </td>
                                  </tr>

                                          <!-- model for update info -->
                                  <div class="modal fade" id="modal-AccountDetailsType-{{$key}}">
                                    <form role="form" method="POST" action="/settings/AccountDetailsType/update" >
                                    {{ csrf_field() }}
                                     {{ method_field('PUT') }}
                                     <input type="hidden" name="id" value="{{$data->detail_type_id}}">
                                     <input type="hidden" name="url" value="{{URL::current()}}">

                                      <input type="hidden" name="tab" value="accounts_details">

                                    <div class="modal-dialog modal-lg">
                                      <div class="modal-content">
                                        <div class="modal-header">
                                          <h4 class="modal-title">Update - {{@$data->dcode}}</h4>
                                          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                          </button>
                                        </div>
                                        <div class="modal-body">
                                          

                                          <div class="row">

                                            <div class="col-md-4">
                                              <div class="form-group">
                                                <label>Account Type</label>
                                                <select class="form-control" name="group_id" >
                                                  <option value="">Select One</option>
                                                  {!!account_type_list(@$data->group_id)!!}
                                                  
                                                </select>
                                              </div>
                                            </div>


                                            <div class="col-md-4">
                                              <div class="form-group">
                                                <label>Root Code</label>
                                                <input type="text" class="form-control" value="{{@$data->account_type->account_type_number}}" readonly>
                                              </div>
                                            </div>

@php     
  if(intval(@$data->dcode)>0){
    $code = @$data->dcode;
    $root_code = @$data->account_type->account_type_number;

    $final_code = substr($code, strlen($root_code));
                                      
  }
@endphp
                                            
                                            <div class="col-md-4">
                                              <div class="form-group">
                                                <label>Code/Account Number *</label>
                                                <input type="text" class="form-control" name="dcode" placeholder="Enter..." value="{{@$final_code}}" required>
                                              </div>
                                            </div>

                                            <div class="col-md-4">
                                              <div class="form-group">
                                                <label>Details Name *</label>
                                                <input type="text" class="form-control" name="detail_type_name" placeholder="Enter..." value="{{@$data->detail_type_name}}" required>
                                              </div>
                                            </div>

                                            <div class="col-md-8">
                                              <div class="form-group">
                                                <label>Description</label>
                                                <textarea class="form-control" name="details" placeholder="Enter...">{{@$data->details}}</textarea>
                                              </div>
                                            </div>                    
                                            
                                          </div>

                                        </div>
                                        <div class="modal-footer justify-content-between">
                                          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                          <button type="submit" class="btn btn-primary">Save changes</button>
                                        </div>
                                      </div>
                                      <!-- /.modal-content -->
                                    </div>

                                    </form>
                                    <!-- /.modal-dialog -->
                                  </div>
                                  <!-- /.modal -->
                                  
                             @endforeach 
                            </tbody>
                              </table>
                            </div>
                            <!-- /.card-body -->
                          </div>
                          <!-- /.card -->
                        </div>
                        <!-- /.col -->
                      </div>
                     
                      
                    </div><!-- /.container-fluid -->


                    <div class="modal fade" id="modal-AccountDetails">
                      <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                          <div class="modal-header">
                            <h4 class="modal-title">Accounts Details Type</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                            </button>
                          </div>

                          <div class="modal-body">

                            <form role="form" method="POST" action="/settings/AccountDetailsType/store">
                            {{ csrf_field() }} 

                            <input type="hidden" name="url" value="{{URL::current()}}">

                            <input type="hidden" name="tab" value="accounts_details">

                            <div class="row">

                                <div class="col-md-12">
                                                        
                                    <div class="panel panel-footer">

                                      <div class="row">


                                        <div class="col-md-4">
                                          <div class="form-group">
                                            <label>Account Type *</label>
                                            <select class="form-control" name="group_id" required>
                                              <option value="">Select One</option>
                                              {!!account_type_list()!!}
                                              
                                            </select>
                                          </div>
                                        </div>

                                        <div class="col-md-4">
                                          <div class="form-group">
                                            <label>Code</label>
                                            <input type="text" class="form-control" readonly>
                                          </div>
                                        </div>

                                        
                                        <div class="col-md-4">
                                          <div class="form-group">
                                            <label>Account Number *</label>
                                            <input type="text" class="form-control" name="dcode" placeholder="Enter..." value="{{old('dcode')}}" required>
                                          </div>
                                        </div>

                                        <div class="col-md-4">
                                          <div class="form-group">
                                            <label>Details Name *</label>
                                            <input type="text" class="form-control" name="detail_type_name" placeholder="Enter..." value="{{old('detail_type_name')}}" required>
                                          </div>
                                        </div>

                                        <div class="col-md-8">
                                          <div class="form-group">
                                            <label>Description</label>
                                            <textarea class="form-control" name="details" placeholder="Enter..."></textarea>
                                          </div>
                                        </div>

                                   
                                    </div>
             
                                      
                                    </div>
                                    <!--/.col (left) -->
                                    
                                  </div>
                            </div>  

                            <div class="" align="right">
                              <button type="submit" class="btn btn-primary"> Save </button>
                            </div>              
                            </form>

                          </div>
                        </div>
                        <!-- /.modal-content -->
                      </div>
                      <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->

                  </div>
                  <!-- end panel AccountDetailsType-->






                  <div class="tab-pane fade {{$Accounts_type}}" id="AccountType" role="tabpanel" aria-labelledby="AccountType-tab">
                    
                    <div class="container-fluid">
                      
                      <div class="row">
                        <!-- /.col -->
                        <div class="col-md-12">
                          <!-- /.card -->

                          <div class="col-md-12" align="right"><button type="button" class="btn btn-primary"data-toggle="modal" data-target="#modal-AccountsType">Add New
                           </button></div>                          


                          <div class="card">

                            <div class="card-body table-responsive p-0">
                              <table class="table table-hover  table-striped">
                                <thead>
                                  <tr>
                                 
                                    <th>Code</th>
                                    <th>Account Type</th>
                                    <th>Root Account</th>
                                    <th>Action</th>
                                  </tr>   
               
                                </thead>
                                <tbody>   
                                  @foreach($data_AccountTypes as $key=>$data)         
                                  <tr>
                                    
                                    <td>{{@$data->account_type_number}}</td>
                                    <td>{{@$data->account_type_name}}</td>
                                    <td>{{@$data->root_account_type->rootID}} - {{@$data->root_account_type->rootName}}</td>
                                    <td>
                                      <button type="button" class="btn btn-default" data-toggle="modal" data-target="#modal-AccountType-{{$key}}">
                                      <i class="fa fa-edit fa-1x"></i>
                                      </button>
                                    </td>
                                  </tr>

                                          <!-- model for update info -->
                                  <div class="modal fade" id="modal-AccountType-{{$key}}">
                                    <form role="form" method="POST" action="/settings/AccountTypes/update" >
                                    {{ csrf_field() }}
                                     {{ method_field('PUT') }}
                                     <input type="hidden" name="id" value="{{$data->account_type_ID}}">
                                     <input type="hidden" name="url" value="{{URL::current()}}">

                                     <input type="hidden" name="tab" value="accounts_type">

                                    <div class="modal-dialog modal-lg">
                                      <div class="modal-content">
                                        <div class="modal-header">
                                          <h4 class="modal-title">Update - {{@$data->account_type_number}}</h4>
                                          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                          </button>
                                        </div>
                                        <div class="modal-body">
                                          <!-- <p>Update Payment History &hellip;</p> -->

                                          <div class="row">

                                            <div class="col-md-4">
                                              <div class="form-group">
                                                <label>Root Account *</label>
                                                <select class="form-control" name="root_id" required>
                                                  <option value="">Select One</option>
                                                  {!! RootAccountType(@$data->root_id) !!}
                                                  
                                                </select>
                                              </div>
                                            </div>  

                                            <div class="col-md-4">
                                              
                                              <div class="form-group">
                                                <label>Code</label>
                                                <input type="text" class="form-control" value="{{@$data->root_account_type->rootID}}" readonly>
                                              </div>
                                            </div>
@php     
  if(intval(@$data->account_type_number)>0){
    $code = @$data->account_type_number;
    $root_code = @$data->root_account_type->rootID;

    $final_code = substr($code, strlen($root_code));                                       
  }
@endphp
                                            <div class="col-md-4">
                                              <div class="form-group">
                                                <label>Account Number *</label>
                                                <input type="text" class="form-control" name="account_type_number" placeholder="Enter..." value="{{@$final_code}}" required>
                                              </div>
                                            </div>

                                            <div class="col-md-4">
                                              <div class="form-group">
                                                <label>Account Type Name *</label>
                                                <input type="text" class="form-control" name="account_type_name" placeholder="Enter..." value="{{@$data->account_type_name}}" required>
                                              </div>
                                            </div>                                
                                                                                   
                                          </div>

                                        </div>
                                        <div class="modal-footer justify-content-between">
                                          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                          <button type="submit" class="btn btn-primary">Save changes</button>
                                        </div>
                                      </div>
                                      <!-- /.modal-content -->
                                    </div>

                                    </form>
                                    <!-- /.modal-dialog -->
                                  </div>
                                  <!-- /.modal -->
                                  
                              @endforeach
                            </tbody>
                              </table>
                            </div>
                            <!-- /.card-body -->
                          </div>
                          <!-- /.card -->
                        </div>
                        <!-- /.col -->
                      </div>
                    
                      
                    </div><!-- /.container-fluid -->

                    <div class="modal fade" id="modal-AccountsType">
                      <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                          <div class="modal-header">
                            <h4 class="modal-title">Accounts Type</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                            </button>
                          </div>

                          <div class="modal-body">

                            <form role="form" method="POST" action="/settings/AccountTypes/store">
                            {{ csrf_field() }}  

                            <input type="hidden" name="url" value="{{URL::current()}}">

                            <input type="hidden" name="tab" value="accounts_type">              
                            
                            <div class="row">

                                <div class="col-md-12">
                                  

                              
                                    <div class="panel panel-footer">

                                      <div class="row">

                                        
                                        <div class="col-md-4">
                                          <div class="form-group">
                                            <label>Root Account *</label>
                                            <select class="form-control" name="root_id" required>
                                              <option value="">Select One</option>
                                              {!! RootAccountType() !!}
                                              
                                            </select>
                                          </div>
                                        </div>  

                                        <div class="col-md-4">
                                          <div class="form-group">
                                            <label>Code</label>
                                            <input type="text" class="form-control" readonly>
                                          </div>
                                        </div>

                                        <div class="col-md-4">
                                          <div class="form-group">
                                            <label>Account Number *</label>
                                            <input type="text" class="form-control" name="account_type_number" placeholder="Enter..." value="{{old('account_type_number')}}" required>
                                          </div>
                                        </div>

                                        <div class="col-md-4">
                                          <div class="form-group">
                                            <label>Account Type Name *</label>
                                            <input type="text" class="form-control" name="account_type_name" placeholder="Enter..." value="{{old('account_type_name')}}" required>
                                          </div>
                                        </div>


                                   
                                    </div>

                                      
                                    </div>
                                    <!--/.col (left) -->
                                    
                                  </div>
                            </div>  

                            <div class="" align="right">
                              <button type="submit" class="btn btn-primary"> Save </button>
                            </div>              
                            </form>

                            
                          </div>
                        </div>
                        <!-- /.modal-content -->
                      </div>
                      <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->

                  </div>
                  <!-- end panel Payment-->



                  <!-- ***************************************************** -->


                </div>
              </div>
              <!-- /.card -->
            </div>
          </div>
        </div>
        <!-- row -->


        </div>
      </div>
    </div>
  </div>
</section>





@stop