@if(userCan('edoctument-create')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif
@extends('layouts.default')
@php $pageTitle = 'Document Upload'; @endphp
@section('title',$pageTitle)
@section('PageHead')

@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
                  </button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  <section class="content">
@endif


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              @if(userCan('edoctument-list')>0)
              <li class="breadcrumb-item "><a href="/elibery/index"> eDocument List </a></li>
              @endif
              @if(userCan('edoctument-create')>0)
              <li class="breadcrumb-item active"><a href="/elibery/index/create"> Add New</a></li>
              @endif
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
@stop


@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <div class="card-body">
                <form method="POST" action="/elibery/index/" role="form" id=""  enctype="multipart/form-data">
                 {{ csrf_field() }}
                  <div class="row">
                  	<div class="col-sm-2">
                      <div class="form-group">
                        <label> Document Type*</label>
                        <select class="form-control" name="doc_type" required>
                          <option value="">-</option>
                          {!!@documentTypeList(old('doc_type'))!!}
                        </select>
                      </div>
                    </div>

                    <div class="col-sm-4">
                      <div class="form-group">
                        <label>Document Name *</label>
                        <input type="text" class="form-control" name="document_name" value="{{old('document_name')}}" placeholder="Enter ..." required >

                      </div>
                    </div>
                    <div class="col-sm-2">
                      <div class="form-group">
                        <label>Document Version</label>
                        <input type="text" class="form-control" name="doc_version" value="{{old('doc_version')}}" placeholder="" >
                      </div>
                    </div>

                    <div class="col-sm-2">
                      <div class="form-group">
                        <label>Issue Number*</label>
                        <input type="text" class="form-control" name="issue_no" value="{{old('issue_no')}}" placeholder=" Issue Number ..." required>
                      </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2">
                      <div class="form-group">
                        <label>Doc. Create Date *</label>
                        <input type="date" class="form-control" name="doc_created" value="{{old('doc_created')}}{{date('Y-m-d')}}"  required>
                      </div>
                    </div>
                    <div class="col-sm-2">
                      <div class="form-group">
                        <label>Doc. Published Date *</label>
                        <input type="date" class="form-control" name="doc_published" value="{{old('doc_published')}}"  required>
                      </div>
                    </div>

                    <div class="col-sm-3">
                      <div class="form-group">
                        <label>Published By </label>
                        <input type="text" class="form-control" name="published_by" value="{{old('published_by')}}" >
                      </div>
                    </div>

                    
                  <!-- </div>

                  <div class="row"> -->
                    
                    <div class="col-md-4">
			          <div class="form-group">
			            <label class=""> File/Attachment  *</label>
			            <input type="file" class="form-control" name="file_name" id="file_name" required >
			          </div>
			        </div>

                  </div>

                  <div class="row">
                  	<div class="col-md-8">
				        <div class="fileinfo">
				        	<br>
				        </div>
			    	</div>

			    	<div class="col-md-4" align="right">
	                  <button type="submit" class="btn btn-primary"> Save </button>
	                </div>
                  </div>

                </form>
              </div>
              <!-- /.card-body -->
          </div>
          <!-- /.col -->
        </div>
       
        
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->

@stop