<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html lang="{{ app()->getLocale() }}">
<html xmlns="http://www.w3.org/1999/xhtml" style="visibility: visible;" lang="en" xml:lang="en">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta name="viewport" content="initial-scale=1.0">
  <meta name="description" content="Customer Secure Login Page. Login to your Account.">
  <title>Login :: @yield('title') {{ config('app.name', 'Panel') }}</title>
  <meta name="format-detection" content="telephone=no">
  <link rel="stylesheet" type="text/css" href="/css/login_style1.css">
<style>
.alert {
    position: relative;
    padding: .75rem 1.25rem;
    margin-bottom: 1rem;
    border: 1px solid transparent;
    border-radius: .25rem;
}
.alert-dismissible {
    padding-right: 4rem;
}
.alert-danger {
    color: #fff;
    background: #dc3545;
    border-color: #d32535;
}
</style>
</head>
<body onload="">
  <div id="left" class="pr">
    <div id="wrap">
      <div id="main">
        @if ( session('massage') )
        <section class="content">
           <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
            <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
            <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i> </button>
            <strong>Success!</strong> {{session('massage')}}
          </div>
        </section>
        @endif
        @if ( session('error') )
        <section class="content">
           <div class="alert alert-danger alert-dismissable remove-button-after-3-sec" style="">
            <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
            <strong>Not Success!</strong> {{session('error')}}
          </div>
        </section>
        @endif

        @if (Session::has('errors'))
          <section class="content">
            <div class="alert alert-danger">
              <ul>
                @foreach ($errors->all() as $error)
                  <li>  {{ $error }}</li>
                @endforeach
              </ul>
            </div>
          <section class="content">
        @endif

        <div id="wrapper">
          <div id="logo_wrapper" class="standard_logo_wrapper mb24">
          <h1 style="height: 100%; display: table-cell; vertical-align: bottom;">
            <img id="logo" class="standard_logo" src="/images/logo2.png" alt="Logo" border="0" name="logo">
          </h1>
          </div>
          <div id="content" style="display: block;">
            <div id="theloginform" style="display: block;">
            
            <form class="form-horizontal" method="POST" action="{{ route('login') }}" autocomplete="off">
              {{ csrf_field() }}

              <div id="usernamegroup" class="inputgroup">
                <label for="username" class="label usernamelabel">Username </label>
                <div id="username_container">
            

                <input class="input r4 wide mb16 mt8 username" type="email" value="{{old('email')}}" name="email" id="username" style="display: block;" required autofocus placeholder="E-Mail Address" >
                @if ($errors->has('email'))
                    <span class="help-block">
                        <strong>{{ $errors->first('email') }}</strong>
                    </span>
                @endif

                </div>
              </div>

              <label for="password" class="label">Password</label>
              <input class="input r4 wide mb16 mt8 password" type="password" id="password"  onkeypress="checkCaps(event)" autocomplete="off" name="password" required placeholder="Password">

                @if ($errors->has('password'))
                    <span class="help-block">
                        <strong>{{ $errors->first('password') }}</strong>
                    </span>
                @endif

              <!-- <input class="button r4 wide primary" type="submit" id="Login" name="Login" value="Log In"> -->
                <button type="submit" class="button r4 wide primary">
                    Log in
                </button>

              <div class="w0 pr ln3 p16 remember">
                <input type="checkbox" class="r4 fl mr8" style="" id="rememberUn" name="remember" 
                {{ old('remember') ? 'checked' : '' }}><label for="remember" class="fl pr db tn3">Remember me</label><br>
              </div>
            </form>

            <div class="w0 links bt pt16 mb20">
              <a id="forgot_password_link" class="fl small" href="{{ route('password.request') }}">Forgot Your Password?</a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div id="footer">© {{date('Y')}} Tech Idea Limited. All rights reserved. | 
    <a id="privacy-link" href="https://www.techi365.com" target="_blank">Privacy</a>
  </div>
</div>


<!-- right side -->
<div id="right" style="background: url('images/login-bg-right.jpg');">
  <h2 style="text-transform: uppercase;">{{ config('app.name', 'Panel') }} FOR BUSINESS  </h2>
  <p style="text-transform: capitalize; font-size: 30px; line-height: 38px; font-weight: 100;"> Perfect destination for HR Training Management System. </p>
  <div style="text-align: center; display: block;">
    <img src="/images/login-right.png" width="60%">
  </div>
</div>
<!-- // end right side -->


</body>
</html>