@if(userCan('ChartOfAccounts-show')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif
@extends('layouts.default')
@php $pageTitle = 'Trial Balance'; @endphp
@section('title',$pageTitle)
@section('PageHead')


@php
 $Date1= app('request')->input('date1');
 $Date2= app('request')->input('date2');
@endphp


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              <li class="breadcrumb-item"><a href="/Reports">Reports</a></li>
              <li class="breadcrumb-item "><a href="?"> {{$pageTitle}} </a></li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

 @stop

@section('content')

   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <!-- /.card -->

            <div class="card">
              <!-- <div class="card-header">
                <h3 class="card-title">Employee List</h3>
              </div>  -->
              <!-- /.card-header -->

              <div class="card-body table-sm p-0 accTreeText" >
                <div align="center">
                  <h2>{{ config('app.appFullName', 'Business Name') }}</h2> 
                  <h6>
                  Trial Balance<br/>
                  
                    {{date('F d, Y')}}  
                  </h6> 
                  <span class="print-on-date">Print On: {{date('d/m/Y h:iA')}}</span> 
                 
                </div>

 

                <table class="table table-sm no-border table-odd-even-color">
                   <thead>
                    <tr class="accTreeTopBorder">
                      <th>Account </th>
                      <th width="200" style="text-align:right !important;">Debit</th>
                      <th width="200" style="text-align:right !important;">Credit</th>
                      <!-- <th width="150">Balance</th> -->
                    </tr>   
 
                  </thead>
                  <tbody>
                    @php $balanceDr = $balanceCr = 0; @endphp                                   
                    @foreach($datas as $key=>$data)   
                       @php 
                        $balance  =$dr =$cr = 0; $lable= '';  
                        if($data->sense==1){ 
                          $lable = ' Dr'; @$dr = $data->DrTotalByAccID->total - $data->CrTotalByAccID->total;
                          $dr += $data->account_opening_balance; 
                          $balanceDr += $dr; 
                        }
                        elseif($data->sense==2){ 
                          $lable = ' Cr'; @$cr = $data->CrTotalByAccID->total - $data->DrTotalByAccID->total; 
                          $cr += $data->account_opening_balance; 
                          $balanceCr += $cr; }
                       @endphp

                       @if($dr!=0 || $cr!=0)
                      <tr>
                        
                        <td title="Open: {{$data->account_opening_balance}}">{{@$data->account_name}}</td>
                        <td align="right">@if($dr!=0){{@number_format($dr,2)}}@endif</td>
                        <td align="right">@if($cr!=0){{number_format(@$cr,2)}}@endif</td>
                        <!-- <td align="right">{{number_format($balance,2)}} {{$lable}}  Dr={{$balanceDr}} Cr={{$balanceCr}} </td> -->
                        
                      </tr>
                      @endif
                    @endforeach

                    <tr class="accTreeBorder2 accHeadTitle">
                        
                        <td> TOTAL</td>
                        <td align="right">{{@number_format($balanceDr,2)}}</td>
                        <td align="right">{{number_format(@$balanceCr,2)}}</td>
                        <!-- <td> </td> -->
                        
                      </tr>
                  </tbody>
                </table>

                


              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
       
        
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
 
@stop