@if(userCan('ChartOfAccounts-show')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif
@extends('layouts.default')
@php $pageTitle = 'Account Profit Loss'; @endphp
@section('title',$pageTitle)
@section('PageHead')


@php
 $Date1= app('request')->input('date1');
 $Date2= app('request')->input('date2');
@endphp


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              <li class="breadcrumb-item"><a href="/Reports">Reports</a></li>
              <li class="breadcrumb-item"><a href="/settings/ChartOfAccounts">Chart of Account</a></li>
              <li class="breadcrumb-item "><a href="?"> {{$pageTitle}} </a></li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

 @stop

@section('content')

   
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <!-- /.card -->

            <div class="card">
              <!-- <div class="card-header">
                <h3 class="card-title">Employee List</h3>
              </div>  -->
              <!-- /.card-header -->

              <div class="card-body table-sm p-0 accTreeText" >
                <div align="center">
                  <h2>{{ config('app.appFullName', 'Business Name') }}</h2> 
                  <h6>
                  Profit Loss Account<br/>
                  @if(intval(@$info['date1'])>0)  As of
                    {{date('F d, Y',strtotime($info['date1']))}}  
                  @endif
                  </h6> 
                  <span class="print-on-date">Print On: {{date('d/m/Y h:iA')}}</span> 
                 
                </div>
<!-- AccRootAccountByID(2)}}
foreach(AccRootAccountByID(2) as $root)
  $root->rootName}}
endforeach -->

                 <br>
@php 
  $rootTotal1 = $rootTotal2 = $rootTotal3 = $rootTotal4 = $rootTotal5 = $rootTotal6 = 0;
  $totalRoot = $totalType = $totalDetails = 0; 
@endphp

<!-- 
1 Application of Funds (Assets)
2 Source of Funds (Liabilities)
4 Income
5 Expense
6 Cost Of Goods Sold
 -->

                <table class="table table-sm no-border">
                  <tbody>
                    <tr style="border-top: 1px solid #999; border-bottom: 1px solid #999;">
                      <td colspan="2" align="right">Total</td>
                    </tr>

                    <!-- 4 Income  -->
                    @foreach(AccRootAccountByID(4) as $root)
                    @php  $totalRoot += $totalType = $totalDetails = $balance =  0; @endphp 
                    @if((RootAccountTypeBalance($root->rootID)) !=0)
                    <tr>
                      <td> 
                        {{$root->rootName}}

                      </td>
                      <td align="right" title="{{RootAccountTypeBalance($root->rootID)}} ">  </td>
                    </tr>
                        @foreach($root->AccountTypes as $type)
                        @if((TypeAccountBalance(@$type->account_type_ID)) !=0)

                          @foreach($type->AccountDetailsTypes as $details)
                            @if((DetailsAccountBalance(@$details->detail_type_id)) !=0)

                          <tr>
                            <td> 
                              <div class="accTreePadding"> &nbsp; </div>  
                              {{@$details->detail_type_name}}  </td>
                            <td align="right" title="{{DetailsAccountBalance(@$details->detail_type_id)}}"> </td>
                          </tr>
                            @foreach($details->AccountName as $account)
                              @if((@$account->DrTotalByAccID->total - @$account->CrTotalByAccID->total) !=0)

                              @php if($account->sense==1) 
                                 $balance = (@$account->DrTotalByAccID->total - @$account->CrTotalByAccID->total);
                              elseif($account->sense==2) 
                                $balance = (@$account->CrTotalByAccID->total - @$account->DrTotalByAccID->total);
                                $totalRoot +=$balance;
                                $totalType +=$balance;
                                $totalDetails +=$balance;
                              @endphp

                              @php  //$totalRoot = $totalType = $totalDetails = 0; @endphp 
                            <tr>
                              <td> 
                                <div class="accTreePadding"> &nbsp; </div> 
                                <div class="accTreePadding"> &nbsp; </div> 
                              <!-- {{@$account->account_number}}   -->
                              {{@$account->account_name}}  </td>
                              <td align="right" title="{{$account->sense==1}} DR: {{@$account->DrTotalByAccID->total}}, CR: {{@$account->CrTotalByAccID->total}}" > 
                                {{number_format($balance,2)}}
                              </td>
                            </tr>
                            @endif
                            <!-- end account -->
                            @endforeach

                          <tr class="accTreeBorder" >
                            <td> 
                                <div class="accTreePadding"> &nbsp; </div> 
                              
                              <b> Total {{@$details->detail_type_name}}   </b></td>
                            <td align="right">  <b>{{number_format($totalDetails,2)}} </b></td>
                          </tr>
                          @php  $totalDetails = $balance =  0; @endphp 
                            @endif 
                            <!-- end details -->
                          @endforeach

                          
                          @php  $totalType = $totalDetails = $balance =  0; @endphp 
                          @endif
                          <!-- end type -->
                        @endforeach

                        <tr class="accTreeBorder" >
                            <td> 
                              <b> Total {{$root->rootName}}  </b></td>
                            <td align="right">  <b>{{number_format($totalRoot,2)}} </b></td>
                          </tr>
                        @php $rootTotal4 = $totalRoot; $totalRoot =  0; @endphp 
                      @endif
                      <!-- end root -->
                    @endforeach
                    
                    <!-- end 4 Income -->


                    <!-- 5 Expense -->
                    @foreach(AccRootAccountByID(5) as $root)
                    @php  $totalRoot += $totalType = $totalDetails = $balance =  0; @endphp 
                    @if((RootAccountTypeBalance($root->rootID)) !=0)
                    <tr>
                      <td> 
                        {{$root->rootName}}

                      </td>
                      <td align="right" title="{{RootAccountTypeBalance($root->rootID)}} ">  </td>
                    </tr>
                        @foreach($root->AccountTypes as $type)
                        @if((TypeAccountBalance(@$type->account_type_ID)) !=0)
                        
                          @foreach($type->AccountDetailsTypes as $details)
                            @if((DetailsAccountBalance(@$details->detail_type_id)) !=0)

                          <tr>
                            <td> 
                              <div class="accTreePadding"> &nbsp; </div> 
                              {{@$details->detail_type_name}}  </td>
                            <td align="right" title="{{DetailsAccountBalance(@$details->detail_type_id)}}"> </td>
                          </tr>
                            @foreach($details->AccountName as $account)
                              @if((@$account->DrTotalByAccID->total - @$account->CrTotalByAccID->total) !=0)

                              @php if($account->sense==1) 
                                 $balance = (@$account->DrTotalByAccID->total - @$account->CrTotalByAccID->total);
                              elseif($account->sense==2) 
                                $balance = (@$account->CrTotalByAccID->total - @$account->DrTotalByAccID->total);
                                $totalRoot +=$balance;
                                $totalType +=$balance;
                                $totalDetails +=$balance;
                              @endphp

                              @php  //$totalRoot = $totalType = $totalDetails = 0; @endphp 
                            <tr>
                              <td> 
                                <div class="accTreePadding"> &nbsp; </div> 
                                <div class="accTreePadding"> &nbsp; </div> 
                              <!-- {{@$account->account_number}}   -->
                              {{@$account->account_name}}  </td>
                              <td align="right" title="{{$account->sense==1}} DR: {{@$account->DrTotalByAccID->total}}, CR: {{@$account->CrTotalByAccID->total}}" > 
                                {{number_format($balance,2)}}
                              </td>
                            </tr>
                            @endif
                            <!-- end account -->
                            @endforeach

                          <tr class="accTreeBorder" >
                            <td> 
                              <div class="accTreePadding"> &nbsp; </div>  
                              <div class="accTreePadding"> &nbsp; </div> 
                              <b> Total {{@$details->detail_type_name}}   </b></td>
                            <td align="right">  <b>{{number_format($totalDetails,2)}} </b></td>
                          </tr>
                          @php  $totalDetails = $balance =  0; @endphp 
                            @endif 
                            <!-- end details -->
                          @endforeach

                          
                          @php  $totalType = $totalDetails = $balance =  0; @endphp 
                          @endif
                          <!-- end type -->
                        @endforeach

                        <tr class="accTreeBorder" >
                            <td> 
                              <b> Total {{$root->rootName}}  </b></td>
                            <td align="right">  <b>{{number_format($totalRoot,2)}} </b></td>
                          </tr>
                        @php $rootTotal5 = $totalRoot; $totalRoot =  0; @endphp 
                      @endif
                      <!-- end root -->
                    @endforeach
                    
                    <!-- end 5 Expense -->

                    <!-- 6 Cost of good sold -->
                    @foreach(AccRootAccountByID(6) as $root)
                    @php  $totalRoot += $totalType = $totalDetails = $balance =  0; @endphp 
                    @if((RootAccountTypeBalance($root->rootID)) !=0)
                    <tr>
                      <td> 
                        {{$root->rootName}}

                      </td>
                      <td align="right" title="{{RootAccountTypeBalance($root->rootID)}} ">  </td>
                    </tr>
                        @foreach($root->AccountTypes as $type)
                        @if((TypeAccountBalance(@$type->account_type_ID)) !=0)
                        <tr>
                          <td> 
                            <div class="accTreePadding"> &nbsp; </div> 
                            <!-- {{@$type->account_type_ID}}   -->
                            {{@$type->account_type_name}}  </td>
                          <td align="right" title="{{TypeAccountBalance(@$type->account_type_ID)}}">   </td>
                        </tr>
                          @foreach($type->AccountDetailsTypes as $details)
                            @if((DetailsAccountBalance(@$details->detail_type_id)) !=0)

                          <tr>
                            <td> 
                              <div class="accTreePadding"> &nbsp; </div>  
                              <div class="accTreePadding"> &nbsp; </div> 
                              {{@$details->detail_type_name}}  </td>
                            <td align="right" title="{{DetailsAccountBalance(@$details->detail_type_id)}}"> </td>
                          </tr>
                            @foreach($details->AccountName as $account)
                              @if((@$account->DrTotalByAccID->total - @$account->CrTotalByAccID->total) !=0)

                              @php if($account->sense==1) 
                                 $balance = (@$account->DrTotalByAccID->total - @$account->CrTotalByAccID->total);
                              elseif($account->sense==2) 
                                $balance = (@$account->CrTotalByAccID->total - @$account->DrTotalByAccID->total);
                                $totalRoot +=$balance;
                                $totalType +=$balance;
                                $totalDetails +=$balance;
                              @endphp

                              @php  //$totalRoot = $totalType = $totalDetails = 0; @endphp 
                            <tr>
                              <td> 
                                <div class="accTreePadding"> &nbsp; </div>  
                                <div class="accTreePadding"> &nbsp; </div> 
                                <div class="accTreePadding"> &nbsp; </div> 
                              <!-- {{@$account->account_number}}   -->
                              {{@$account->account_name}}  </td>
                              <td align="right" title="{{$account->sense==1}} DR: {{@$account->DrTotalByAccID->total}}, CR: {{@$account->CrTotalByAccID->total}}" > 
                                {{number_format($balance,2)}}
                              </td>
                            </tr>
                            @endif
                            <!-- end account -->
                            @endforeach

                          <tr class="accTreeBorder" >
                            <td> 
                              <div class="accTreePadding"> &nbsp; </div>  
                              <div class="accTreePadding"> &nbsp; </div> 
                              <b> Total {{@$details->detail_type_name}}   </b></td>
                            <td align="right">  <b>{{number_format($totalDetails,2)}} </b></td>
                          </tr>
                          @php  $totalDetails = $balance =  0; @endphp 
                            @endif 
                            <!-- end details -->
                          @endforeach

                          <tr class="accTreeBorder" >
                            <td> 
                              <div class="accTreePadding"> &nbsp; </div>  
                              <b> Total {{@$type->account_type_name}}  </b></td>
                            <td align="right">  <b>{{number_format($totalType,2)}} </b></td>
                          </tr>
                          @php  $totalType = $totalDetails = $balance =  0; @endphp 
                          @endif
                          <!-- end type -->
                        @endforeach

                        <tr class="accTreeBorder" >
                            <td> 
                              <b> Total {{$root->rootName}}  </b></td>
                            <td align="right">  <b>{{number_format($totalRoot,2)}} </b></td>
                          </tr>
                        @php $rootTotal6 = $totalRoot; $totalRoot =  0; @endphp 
                      @endif
                      <!-- end root -->
                    @endforeach
                    
                    <!-- end 6 Cost of Good Sold -->

                  
                  @php $netIncome = $rootTotal4-$rootTotal5-$rootTotal6 @endphp

                    <tr class="accTreeBorder" >
                      <td> 
                        <b> Net Income   </b></td>
                      <td align="right">  <b>{{number_format($netIncome,2)}} </b></td>
                    </tr>

                  </tbody>
                </table>

                


              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
       
        
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
 
@stop