@extends('app.layout')
@section('content')
@inject('Cfunc', 'App\CommonFunction\CommonFunction')
<section class="content-header" style="padding: 15px 0 10px 0">
	<h1>Dashboard</h1>
	<ol class="breadcrumb">
		<li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
		<li class="active"><a href="/Authentication/Permission/List">Permission</a></li>
		<li class="active"><a href="/Authentication/Permission/List/Add/New">Create Permission</a></li>
	</ol>
</section>


@if ( session('massage') )
<section >
	<div class="alert alert-success alert-dismissable remove-button-after-3-sec">
		<a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
		<strong>Success!</strong> {{session('massage')}}
	</div>
</section>
@endif



<div class="box box-primary">
  <div class="box-header">
    <h3 class="box-title">Permission list</h3>
  </div>
  <!-- /.box-header -->
  <div class="box-body">
    <table id="example1" class="table table-bordered table-striped">
      <thead>
        <tr>
			<th >Name</th>
			<th >Display Name</th>
			<th>Description</th>
			<th>Create Date</th>
			<th>Action</th>
        </tr>
      </thead>
      <tbody>
       @foreach($permissions as $key => $permission)
        <tr>
			<td >{{ $permission->name }}</td>
			<td  >{{ $permission->display_name }}</td>
			<td>{{$permission->description}}</td>
			<td>{{date('F j,Y',strtotime($permission->created_at))}}</td>
			<td>
			@php 
			$link = '/Authentication/Permission/List/'.$permission->id.'/Edit';
			@endphp

			{!! $Cfunc->edit_link($link) !!}
			</td>
        
        </tr>
       @endforeach
       
      </tbody>
    </table>
  </div>
  <!-- /.box-body -->
  <div class="box-footer">
  	{{ $permissions->links() }}
  </div>
</div>
<!-- /.box -->

<!-- box-end -->

@endsection