@extends('app.layout')
@section('content')
<section class="content-header" style="padding: 15px 0 10px 0">
	<h1>Dashboard</h1>
	<ol class="breadcrumb">
		<li><a href="/"><i class="fa fa-dashboard"></i> Home</a></li>
		<li class="active"><a href="/Authentication/Permission/List">Permission</a></li>
		<li class="active"><a href="/Authentication/Permission/List/Add/New">Create Permission</a></li>
	</ol>
</section>


@if ( session('massage') )
<section >
	<div class="alert alert-success alert-dismissable remove-button-after-3-sec">
		<a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
		<strong>Success!</strong> {{session('massage')}}
	</div>
</section>
@endif

<div class="box box-primary">
  <div class="box-header">
    <h3 class="box-title">Update Permission</h3>
  </div>
  <!-- /.box-header -->
  <form method="POST" action="/Authentication/Permission/List/{{$permission->id}}"  >
    {{ csrf_field() }}
    {{method_field('PATCH')}}
    <div class="box-body">

    <div class="row">
      <div class="col-md-6 {{ $errors->has('name') ? ' has-error' : '' }} ">
        <div class="from-group">

          <label for="name" >Name <span  title="Required">*</span></label>
          <input type="text"   class="form-control "  name="name" id="name"  placeholder="create-invoice" value="{{$permission->name}}" required>

          @if ($errors->has('name'))
          <span class="help-block">
            <strong>{{ $errors->first('name') }}</strong>
          </span>
          @endif
        </div>
      </div>
      <div class="col-md-6 {{ $errors->has('display_name') ? ' has-error' : '' }}">
        <div class="from-group">
          <label for="display_name" >Display Name</label>
          <input type="text" 
          name="display_name" 
          id="display_name" 
          class="form-control "
          placeholder="Create Invoice" value="{{$permission->display_name}}">
          @if ($errors->has('display_name'))
          <span class="help-block">
            <strong>{{ $errors->first('display_name') }}</strong>
          </span>
          @endif
        </div>
      </div>
    </div>

    <div class="row">

      <div class="col-md-12">
        <div class="form-group">
          <label >Description</label>
            <textarea style="resize:none" class="form-control " 
            name="description" placeholder="User Who Can Create Invoice">{{$permission->description}}</textarea>
        </div>
      </div>

    </div>

  </div>
  <!-- /.box-body -->
   <div class="box-footer">
    <button type="submit" class="btn btn-primary">
                Update 
            </button>
    </div>
</form>

</div>
<!-- /.box -->
<!-- box-end -->
@endsection
