@if(userCan('Transporter-create')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif
@extends('layouts.default')
@php $pageTitle = 'New Transporter'; @endphp
@section('title',$pageTitle)
@section('PageHead')

@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
                  </button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  </section>
  
@endif


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              @if(userCan('setting-list')>0)
              <li class="breadcrumb-item "><a href="/settings"> Settings </a></li>
              @endif
              @if(userCan('Transporter-list')>0)
              <li class="breadcrumb-item "><a href="/settings/Transporter"> Transporter List </a></li>
              @endif
              @if(userCan('Transporter-create')>0)
              <li class="breadcrumb-item active"><a href="/settings/Transporter/create/">Add New</a></li>
              @endif
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->

    </div>
    <!-- /.content-header -->
@stop

@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <div class="card-body">
                <form method="POST" action="/settings/Transporter/store" role="form" id="">
                 {{ csrf_field() }}
                 
                  <div class="row">

                    <div class="col-sm-4">
                      <div class="form-group">
                        <label>Category</label>
                        <select class="form-control" name="category" >
                          <option value="">Select One</option>
                        </select>
                      </div>
                    </div>

                    <div class="col-sm-2">
                      <div class="form-group">
                        <label>Carrier Code</label>
                        <input type="text" class="form-control" name="code" value="{{old('code')}}" placeholder="Enter ..." >
                      </div>
                    </div>

                    <div class="col-sm-6">
                      <div class="form-group">
                        <label>Transporter Name</label>
                        <input type="text" class="form-control" name="name" value="{{old('code')}}" placeholder="Enter ..." >
                      </div>
                    </div>

                    <div class="col-sm-4">
                      <div class="form-group">
                        <label>Mobile</label>
                        <input type="text" class="form-control" name="mobile" value="{{old('code')}}" placeholder="Enter ..." >
                      </div>
                    </div>

                    <div class="col-sm-4">
                      <div class="form-group">
                        <label>Email</label>
                        <input type="text" class="form-control" name="email" value="" placeholder="Enter ..." >
                      </div>
                    </div>

                    <div class="col-sm-4">
                      <div class="form-group">
                        <label>Address</label>
                        <textarea rows="3" class="form-control" name="address" value="{{old('code')}}" placeholder="Enter ..."></textarea>
                      </div>
                    </div>


                      <div class="col-md-12">
                            <!-- jquery validation -->
                            <div class="card card-primary">
                              <div class="card-header">
                                <h3 class="card-title">Transporter Details</h3>
                              </div>
                              <!-- /.card-header -->
                              <!-- form start -->
                        
                                <div class="panel panel-footer">
                            <table class="table table-bordered">
                              <thead>
                                <tr>
                                  <th>Type</th>          
                                  <th>Registration No</th>
                                  <th>Identification No</th>
                                  <th>Status</th>
                                  <th><span class="btn btn-primary addRow"><i class="fa fa-plus"></i></span></th>
                                </tr>   
                              </thead>
                              <tbody> 
                                <tr>
                                  <td>
                                    <select class="form-control" name="nnnnn" >
                                      <option value="">Select One</option>
                                    </select>
                                  </td>

                                  <td>
                                    <input type="text" class="form-control" name="nnnnn" value="{{old('nnnnn')}}" placeholder="">
                                  </td>

                                  <td>
                                    <input type="text" class="form-control" name="nnnnn" value="{{old('nnnnn')}}" placeholder="">
                                  </td>

                                  <td>
                                    <select class="form-control" name="nnnnn" >
                                      <option value="">Select One</option>
                                    </select>
                                  </td>

                                  <td>
                                    <a href="javascript:void(0)" class="btn btn-danger remove"><i class="fa fa-minus"></i></a>
                                  </td>
                                </tr>
                            
                              </tbody>
                            </table>
                          </div>
                          <!--/.col (left) -->
                          </div>
                          <!-- /.card -->
                        </div>
                </div>

                <div class="col-md-12">
                  <br>
                  <div class="" align="right">
                    <button type="submit" class="btn btn-primary"> Save </button>
                  </div>
                </div>

               </div>
               <!-- /end row -->


                </form>
              </div>
              <!-- /.card-body -->
                        </div>
          <!-- /.col -->
        </div>
       
        
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->

  <script type="text/javascript">
  $('.addRow').on('click',function(){
    addRow();
  });
  function addRow()
  {
    var tr='<tr>'+
    '<td><select class="form-control" name="nnnnn" ><option value="">Select One</option></select></td>'+'<td><input type="text" class="form-control" name="nnnnn" value="{{old('nnnnn')}}" placeholder=""></td>'+'<td><input type="text" class="form-control" name="nnnnn" value="{{old('nnnnn')}}" placeholder=""></td>'+'<td><select class="form-control" name="nnnnn" ><option value="">Select One</option></select></td>'+'<td><a href="javascript:void(0)" class="btn btn-danger remove"><i class="fa fa-minus"></a></td>'+'</tr>';
    $('tbody').append(tr);
  };
  $('.remove').live('click',function(){
    var last=$('tbody tr').length;
    if(last==1){
      alert("You have to keep last row3.")
    }
    else{
      $(this).parent().parent().remove();
    }
  });
</script>

@stop