@if(userCan('company-create')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif
@extends('layouts.default')
@php $pageTitle = 'New Company '; @endphp
@section('title',$pageTitle)
@section('PageHead')

@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
                  </button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  <section class="content">
@endif


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              @if(userCan('setting-list')>0)
              <li class="breadcrumb-item "><a href="/settings"> Settings </a></li>
              @endif
              @if(userCan('company-list')>0)
              <li class="breadcrumb-item "><a href="/settings/company"> Company List </a></li>
              @endif
              @if(userCan('company-create')>0)
              <li class="breadcrumb-item active"><a href="/settings/company/create"> Add New</a></li>
              @endif
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
@stop

@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <div class="card-body">
                <form method="POST" action="/settings/company/store" role="form" id="">
                 {{ csrf_field() }}
                  <div class="row">
                    <div class="col-sm-5">
                      <div class="form-group">
                        <label>Company Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="name" value="{{old('name')}}" placeholder="Enter ..." required >
                      </div>
                    </div>

                    <div class="col-sm-1">
                      <div class="form-group">
                        <label>Prefix</label>
                        <input type="text" class="form-control" name="prefix" value="{{old('contact')}}" placeholder="Enter ..." >
                      </div>
                    </div>

                    <div class="col-sm-3">
                      <div class="form-group">
                        <label>Type</label>
                        <select class="form-control" name="company_type" >
                          <option value="">-</option>
                          {!!companyType()!!}
                        </select>
                      </div>
                    </div>
                     
                    <div class="col-sm-3">
                      <div class="form-group">
                        <label> Establishment</label>
                        <input type="date" name="establishment" value="{{old('establishment')}}" class="form-control" autocomplete="off" >
                      </div>
                    </div>

                    <div class="col-sm-3">
                      <div class="form-group">
                        <label>Phone</label>
                        <input type="text" class="form-control" name="contact" value="{{old('contact')}}" placeholder="Enter ..." >
                      </div>
                    </div>

                    

                    <div class="col-sm-4">
                      <div class="form-group">
                        <label>Email</label>
                        <input type="text" class="form-control" name="email" value="{{old('email')}}" placeholder="Enter ..." >
                      </div>
                    </div>
                    
                    

                    <div class="col-sm-5">
                      <div class="form-group">
                        <label>Parent Company</label>
                        <select class="form-control" name="parent" >
                          <option value="">-</option>
                          {!!@company_list()!!}
                        </select>
                      </div>
                    </div>
                    
                  </div>

                  <div class="row">
                <!-- left column -->
                <div class="col-md-12">
                  <!-- jquery validation -->
                  <div class="card card-warning">
                    <div class="card-header">
                      <h3 class="card-title"> Primary Contact Information </h3>
                    </div>
                    <!-- /.card-header -->
                    <!-- form start -->
              
                      <div class="card-body">
                        <div class="row">
                        <div class="col-sm-3">
                          <div class="form-group">
                            <label> Contact Name</label>
                            <input type="text" name="primary_contact_name" value="{{old('primary_contact_name')}}" class="form-control" autocomplete="off" placeholder="Enter ..." >
                          </div>
                        </div>

                        <div class="col-sm-3">
                          <div class="form-group">
                            <label> Contact Designation</label>
                            <input type="text" name="primary_contact_designation" value="{{old('primary_contact_designation')}}" class="form-control" autocomplete="off" placeholder="Enter ..." >
                          </div>
                        </div>

                        <div class="col-sm-3">
                          <div class="form-group">
                            <label> Contact Number</label>
                            <input type="text" name="primary_contact_number" value="{{old('primary_contact_number')}}" class="form-control" autocomplete="off" placeholder="Enter ..." >
                          </div>
                        </div>

                      <div class="col-sm-3">
                        <div class="form-group">
                          <label> Contact Email</label>
                          <input type="text" name="primary_conatct_email" value="{{old('primary_conatct_email')}}" class="form-control" autocomplete="off" placeholder="Enter ..." >
                        </div>
                      </div>  
                      </div>
                      <!-- /.card-body -->
                    </div>
                  <!-- /.card -->
                  </div>
                <!--/.col (left) -->
              </div> 
              </div>

                <div class="row">
                <!-- left column -->
                <div class="col-md-12">
                  <!-- jquery validation -->
                  <div class="card card-primary">
                    <div class="card-header">
                      <h3 class="card-title"> Address </h3>
                    </div>
                    <!-- /.card-header -->
                    <!-- form start -->
              
                      <div class="card-body">
                        <div class="row">
                        <div class="col-sm-6">
                        <div class="form-group">
                          <textarea class="form-control" name="address" placeholder="Full Address">{{old('address')}}</textarea>
                        </div>
                      </div>

                        <div class="col-sm-3">
                          <div class="form-group">
                            <input type="text" class="form-control" name="city" value="{{old('contact')}}" placeholder="City" >
                          </div>
                        </div>

                        <div class="col-sm-3">
                      <div class="form-group">
                        <input type="text" class="form-control" name="division" value="{{old('contact')}}" placeholder="Division/State" >
                      </div>
                    </div>
                      </div>
                      <!-- /.card-body -->
                    </div>
                  <!-- /.card -->
                  </div>
                <!--/.col (left) -->
              </div> 
              </div>

                <div class="col-md-12">
                  <br>
                  <div class="" align="right">
                    <button type="submit" class="btn btn-primary"> Save </button>
                  </div>
                </div>

               </div>
               <!-- /end row -->


                </form>
              </div>
              <!-- /.card-body -->
          </div>
          <!-- /.col -->
        </div>
       
        
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->




@stop