@if(userCan('SetProviderName-edit')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif
@extends('layouts.default')
@php $pageTitle = 'Update Provider Name'; @endphp
@section('title',$pageTitle)
@section('PageHead')

@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
                  </button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  <section class="content">
@endif


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              @if(userCan('setting-list')>0)
              <li class="breadcrumb-item "><a href="/settings"> Settings </a></li>
              @endif
              @if(userCan('SetProviderName-list')>0)
              <li class="breadcrumb-item "><a href="/settings/SetProviderName"> Provider Name List </a></li>
              @endif
              @if(userCan('SetProviderName-create')>0)
              <li class="breadcrumb-item active"><a href="/settings/SetProviderName/create/"> Add New</a></li>
              @endif
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
@stop

@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <div class="card-body">
                <form method="POST" action="/settings/SetProviderName/update" role="form" id="">
                 {{ csrf_field() }}
                 @method('PUT')
                 <input type="hidden" name="id" value="{{$data->id}}">
                 <input type="hidden" name="url" value="{{URL::previous()}}">
                  <div class="row">

                    <div class="col-sm-5">
                      <div class="form-group">
                        <label>Provider Name</label>
                        <input type="text" class="form-control" name="bankName" placeholder="Enter..." value="{{@$data->bankName}}" >
                      </div>
                    </div>

                    <div class="col-sm-4">
                      <div class="form-group">
                        <label>Type</label>
                        <select class="form-control" name="type" >
                          <option value="">Select One</option>
                          <option value="1" {{ (@$data->type=="1")? "selected" : "" }}>Bank</option>
                          <option value="2" {{ (@$data->type=="2")? "selected" : "" }}>Mobile(MFS)</option>
                          <option value="3" {{ (@$data->type=="3")? "selected" : "" }}>Online</option>
                          <option value="4" {{ (@$data->type=="4")? "selected" : "" }}>Others</option>
                        </select>
                      </div>
                    </div>

                    <div class="col-sm-2">
                      <div class="form-group">
                        <label>Status</label>
                        <select class="form-control contact_status_action_edit" name="status" >
                          <option value="">Select One</option>
                          <option value="1" {{ (@$data->status=="1")? "selected" : "" }}>Active</option>
                          <option value="0" {{ (@$data->status=="0")? "selected" : "" }}>Deactive</option>
                        </select>
                      </div>
                    </div>     
                                   
                    </div>  
                  </div>
                    </div>    
                  </div>



                
                <div class="col-md-12">
                  <br>
                  <div class="" align="right">
                    <button type="submit" class="btn btn-primary"> Save </button>
                  </div>
                </div>

               </div>
               <!-- /end row -->

                </form>
              </div>
              <!-- /.card-body -->
          </div>
          <!-- /.col -->
        </div>
       
        
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->




@stop