@if(userCan('SetKeyConfig-list')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif

@extends('layouts.default')
@php $pageTitle = 'Key List'; @endphp
@section('title',$pageTitle)
@section('PageHead')

@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
                  </button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  <section class="content">
@endif

@php
 $KeyName= app('request')->input('key_name');
 $Value= app('request')->input('value');
 $StatusId= app('request')->input('status');
 $perpage = ((app('request')->input('plimit'))>0) ? app('request')->input('plimit') : 50;
@endphp


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              @if(userCan('setting-list')>0)
              <li class="breadcrumb-item "><a href="/settings"> Settings </a></li>
              @endif
               @if(userCan('SetKeyConfig-list')>0)
              <li class="breadcrumb-item "><a href="?"> {{$pageTitle}} </a></li>
              @endif
              @if(userCan('SetKeyConfig-create')>0)
              <li class="breadcrumb-item active"><a href="/settings/SetKeyConfig/create/"> Add New</a></li>
              @endif
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

<section class="content">
    <div class="container-fluid card">
        <form method="" action="" role="form" >
        <div class="row">

            
            <div class="col-md-3">
              Key Name
              <input type="" name="key_name" value="{{app('request')->input('key_name')}}" class="form-control" autocomplete="off" >
            </div>

            <div class="col-md-3">
              Value
              <input type="" name="value" value="{{app('request')->input('value')}}" class="form-control" autocomplete="off" >
            </div>

            <div class="col-md-2">
            Status<br>
            <select name="status" id="status" class="form-control"  >
              <option value=""> All </option>
              {!! statusIs(app('request')->input('status')) !!}
            </select>
          </div>  
            
            <div class="col-md-2">
                <br>
              <button type="submit" class="btn btn-default btn-sm">
                <i class="fas fa-search"></i>
              </button>
            </div>
            
          
        </div>
        <!--// row-->
        </form>
        <br>
    </div>
    <!--// container-fluid-->
</section>
<!--// end section-->

 @stop

@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <!-- /.card -->
            <div class="card">

              <div class="col-md-12" >
              {{paginationHeaderInfo($datas)}}
                <div class="col-md-12 pagination-area" >
                  {{$datas->appends([              
                    'key_name' => $KeyName,
                    'value' => $Value,
                    'plimit' => $perpage,
                    'status' => $StatusId
                  ])->links('pagination::bootstrap-4')}}
                </div>
              </div>

              <div class="card-body table-responsive p-0 textCapital">
                <table class="table table-hover table-striped">
                  <thead>
                    <tr>
                      <th >Key Name</th>
                      <th>Value</th>
                      <th >Disc</th>
                      <th>Notes</th>
                      <th>Status</th>
                      <th>Action</th>
                    </tr>   
 
                  </thead>
                  <tbody>
                    @foreach($datas as $key=>$data)

              
          
                    <tr>
                      <td>
                        {{@$data->key_name}}
                      </td>

                      <td>
                        {{@$data->value}}
                      </td>

                      <td>
                        {{@$data->disc}}
                      </td>
                      
                      <td>
                        {{@$data->sys_notes}}
                      </td>
                      <td>
                        @if(intval(@$data->status)>0) Active @else Deactive @endif
                      </td>

                      
                      <td>
                        @if(userCan('SetKeyConfig-edit')>0)
                        <a href="/settings/SetKeyConfig/{{$data->id}}/edit"> <i class="fa fa-edit"></i></a>
                        @endif
                      </td>
                    </tr>
                  @endforeach
                  </tbody>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>

        <div class="col-md-12" >
          {{paginationHeaderInfo($datas)}}
            <div class="col-md-12 pagination-area" >
              {{$datas->appends([              
                'key_name' => $KeyName,
                'value' => $Value,
                'plimit' => $perpage,
                'status' => $StatusId
              ])->links('pagination::bootstrap-4')}}
            </div>
          </div>
       
        
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
 
@stop