@if(userCan('ProductCategory-list')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif
@extends('layouts.default')
@php $pageTitle = 'Product Category List'; @endphp
@section('title',$pageTitle)
@section('PageHead')
@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
</button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  <section class="content">
@endif

@php
 $CategoryName= app('request')->input('category_name');
 $ParentCatId= app('request')->input('parent_cat_id');
 $Status= app('request')->input('status');
 $appPerPage= app('request')->input('perPage');
@endphp

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-5">
        <h3 class="card-title">{{$pageTitle}}</h3>
      </div><!-- /.col -->
      <div class="col-sm-7">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
          @if(userCan('setting-list')>0)
            <li class="breadcrumb-item "><a href="/settings"> Settings </a></li>
          @endif
          @if(userCan('ProductCategory-list')>0)
          <li class="breadcrumb-item "><a href="?"> {{$pageTitle}} </a></li>
          @endif
          @if(userCan('ProductCategory-create')>0)
          <li class="breadcrumb-item active"><a href="/settings/productCategory/create/"> Add New</a></li>
          @endif
        </ol>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

@stop
@section('content')
<!-- Main content -->
<section class="content">
  <div class="container-fluid">
    <div class="row">
      <!-- /.col -->
      <div class="col-md-12">
        <!-- /.card -->
        <div class="card">

           <form method="get" action="" role="form" >
                
              <div class="card-header">

              Per Page
                @php  $curentperPagesnum = isset($_GET['perPage'])?$_GET['perPage']:10; @endphp
                @php  $perPages = array(10,15,20,50,100,500,1000);@endphp
                <select name="perPage" id="perPage" onchange="this.form.submit()">
                  <option value="{{@$appPerPage}}">Select All</option>
                  @foreach( $perPages as $key =>$perPagesnum )
                  <option @if($curentperPagesnum == $perPagesnum) selected="selected" @endif value="{{$perPagesnum}}">{{$perPagesnum}}</option>
                  @endforeach
                </select>
   

              <div class="card-tools">
                <div class="input-group" style="width: auto">

                    <div class="col-md-4">
                      <label>Category Name</label>
                      <input type="text" class="form-control" name="category_name" value="{{@$CategoryName}}">
                    </div>

                    <div class="col-md-4">
                      <label>Parent Category Name</label>
                      <select class="form-control select2" name="parent_cat_id" onchange0="this.form.submit()">
                          <option value=""> All </option>
                        {!! product_category(@$ParentCatId) !!}  
                      </select>
                    </div>

                    <div class="col-md-3">
                      <label>Status</label>
                      <select class="form-control" name="status" onchange0="this.form.submit()">
                        <option value=""> All </option>
                        {!!statusIs(@$Status)!!}
                      </select>
                    </div>

                  <div class="col-md-1">
                    <label>Search</label>
                    <button type="submit" class="btn btn-default btn-sm" onchange="this.form.submit()">
                      <i class="fas fa-search"></i>
                    </button>
                  </div>
                </div>
              </div>
            </div>
            </form>

            <div class="col-md-12" >
              {{paginationHeaderInfo($datas)}}
                <div class="col-md-12 pagination-area" >
                  {{$datas->appends([              
                    'category_name' => $CategoryName,
                    'parent_cat_id' => $ParentCatId,
                    'status' => $Status
                  ])->links('pagination::bootstrap-4')}}
                </div>
            </div>
            <hr>

          <div class="card-body table-responsive p-0 textCapital">
            <table class="table table-hover  table-striped">
              <thead>
                <tr>
                  <th>ID</th>
                  <th>Category Name</th>
                  <th>Parent Category</th>
                  <th>Status</th>
                  <th>Action</th>
                </tr>   
              </thead>
              <tbody>
                @foreach($datas as $key=>$data)
                <tr>
                  <td>
                    {{@$data->catID}}
                  </td><td>
                    {{@$data->catName}}
                  </td>
                  </td><td>
                    {{@$data->ProductCategorie->catName}}
                  </td>
                  <td>
                    @if(intval(@$data->status)>0) Active @else Deactive @endif
                  </td>
                  <td>
                    @if(userCan('ProductCategory')>0)
                    <a href="#"> <i class="far fa-eye" ></i></a>
                    @endif

                    @if(userCan('ProductCategory-edit')>0)
                    <a href="/settings/productCategory/{{@$data->catID}}/edit"> <i class="fa fa-edit" ></i></a>
                    @endif

                    @if(userCan('ProductCategory')>0)
                    <a href="#"> <i class="far fa-file-alt" ></i></a>
                    @endif
                  </td>
                </tr>
                @endforeach
              </tbody>
            </table>
          </div>
          <!-- /.card-body -->
        </div>
        <!-- /.card -->
      </div>
      <!-- /.col -->
    </div>

    <div class="col-md-12" >
      {{paginationHeaderInfo($datas)}}
        <div class="col-md-12 pagination-area" >
          {{$datas->appends([              
            'category_name' => $CategoryName,
            'parent_cat_id' => $ParentCatId,
            'status' => $Status
          ])->links('pagination::bootstrap-4')}}
        </div>
    </div>


  </div><!-- /.container-fluid -->
</section>
<!-- /.content -->

@stop