@if(userCan('ConfirmationDueDetails-List')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif
@extends('layouts.default')
@php $pageTitle = 'Confirmation Due Details List'; @endphp
@section('title',$pageTitle)
@section('PageHead')

@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
                  </button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  <section class="content">
@endif


<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              
              @if(userCan('ConfirmationDueDetails-List')>0)
              <li class="breadcrumb-item "><a href="/Confirmation/ConfirmationDue"> Confirmation Due List </a></li>
              @endif
              
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
        <form method="" action="" role="form" id="">
                 {{ csrf_field() }} 
                @method('PUT')
                <div class="card-header">
                Per Page
                  <select name="limit" class="">
                      <option value="10" > 10 </option>
                      <option value="25">25</option>
                      <option value="50">50</option>
                      <option value="100">100</option>
                  </select>
                <div class="card-tools">
                  <div class="input-group" style="width: auto">
                    <input type="text" name="searchin"
                      class="form-control form-control-sm float-right"
                      placeholder="Search">
                    <div class="input-group-append ">
                      <!-- <label>Satus</label> -->
                      <select name="searchfor"
                        class="custom-select custom-select-sm form-control form-control-sm">
                        <option value="">Search - All</option>
                        <option value="1" >Active</option>
                        <option value="0" >In-Active</option>
                      </select>
                    </div>

                    <div class="input-group-append">
                      <button type="submit" class="btn btn-default btn-sm">
                        <i class="fas fa-search"></i>
                      </button>
                    </div>
                  </div>
                </div>
              </div>
              </form>
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
@stop

@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <!-- /.col -->
          <div class="col-md-12">
            <div class="card-body">  
                  <div class="row">

                    <div class="col-md-2">
                      <div class="form-group">
                        <label>From</label>
                        <input type="date" class="form-control" name="name" value="{{old('name')}}" >
                      </div>
                    </div>

                    <div class="col-md-2">
                      <div class="form-group">
                        <label>To</label>
                        <input type="date" class="form-control" name="name" value="{{old('name')}}" >
                      </div>
                    </div>

                    <div class="col-md-2">
                      <div class="form-group">
                        <label>Staff</label>
                        <select class="form-control" name="company_id" >
                          <option value="">Select One</option>
                          MMH
                        </select>
                      </div>
                    </div>

                    <div class="col-md-2">
                      <div class="form-group">
                        <label>Department</label>
                        <select class="form-control" name="company_id" >
                          <option value="">Select One</option>
                          MMH
                        </select>
                      </div>
                    </div>

                    <div class="col-md-1">
                      <div class="form-group">
                        <label>Due</label>
                        <input type="text" class="form-control" name="name" value="{{old('name')}}" >
                      </div>
                    </div>

                    <div class="topnav">
                        <a href="#">Confirmation Process</a> 
                    </div>
                  </div>
                 <!-- /end row -->
                    
                   
                  <div class="row"> 
                    <div class="card-body table-responsive p-0 textCapital">
                <table class="table table-hover table-striped">
                  <thead>
                    <tr>
                      <th>Staff</th>
                      <th>Department</th>
                      <th>Company</th>
                      <th>Joining Date</th>
                      <th>Due Date</th>
                      <th>Status</th>
                      <th>Select</th>
                      <th>Action</th>
                    </tr>   
 
                  </thead>
                  <tbody>
                   @foreach($datas as $key=>$data)
                    <tr>
                      <td>
                        {{@$data->full_name}}
                      </td>

                      <td>
                        {{@$data->empDepartment->department}}
                        <br>
                        <span class="text-blue">{{@$data->empDesignation->designation}} </span>
                      </td>

                      <td>
                        {{@$data->EmpCompanyName->name}}
                        
                      </td>

                      <td>
                        {{@$data->joining_date}}
                      </td>

                      <td>
                        {{@$data->confirmation_date}}
                      </td>

                      <td>
                        Name
                      </td>

                      <td>
                        <input type="checkbox" name="checkbox" value="" >
                      </td>
     
                      <td>

                        @if(userCan('Attendance')>0)
                        <a href="#"> <i class="far fa-eye" style='font-size:18px;color:black'></i></a>
                        @endif

                        @if(userCan('Attendance')>0)
                        <a href="/Confirmation/ConfirmationRecommendation/{{$data->id}}/create/"> <i class="fas fa-arrow-alt-circle-right" style='font-size:18px;color:black'></i></a>
                        @endif

                      </td>
                    </tr>
                  @endforeach
                  </tbody>
                </table>
              </div>
                  </div>
                 <!-- /end row -->

              </div>
              <!-- /.card-body -->
          </div>
          <!-- /.col -->
        </div>
       
        
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->




@stop