@if(userCan('user-list')==0) @php header("Location: " . URL::to('errors.403'), true, 302); exit(); @endphp @endphp @endif
@extends('layouts.default')
@php $pageTitle = 'User List '; @endphp
@section('title',$pageTitle)
@section('PageHead')

<style>
  .span-styleing {
    background-color: #3c8dbc;
    border-color: #367fa9;
    padding: 5px 5px;
    color: #fff;
    border-radius: 4px;
}
</style>

@if ( session('massage') )
<section class="content">
   <div class="alert alert-success alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fas fa-times"></i>
                  </button>
    <strong>Success!</strong> {{session('massage')}}
  </div>
</section>
@endif
@if ( session('error') )
<section class="content">
   <div class="alert alert-danger alert-dismissable remove-button-after-3-sec">
    <a href="#" class="close" data-dismiss="alert" aria-label="close">×</a>
    <strong>Not Success!</strong> {{session('error')}}
  </div>
</section>
@endif

@if (Session::has('errors'))
  <section class="content">
    <div class="alert alert-danger">
      <ul>
        @foreach ($errors->all() as $error)
          <li>  {{ $error }}</li>
        @endforeach
      </ul>
    </div>
  </section>
@endif




<!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-5">
            <h3 class="card-title">{{@$pageTitle}}</h3>
          </div><!-- /.col -->
          <div class="col-sm-7">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/">Dashboard</a></li>
              @if(userCan('user-list')>0)
              <li class="breadcrumb-item "><a href="/settings/users"> User List </a></li>
              @endif

              @if(userCan('user-create')>0)
              <li class="breadcrumb-item "><a href="{{ route('register') }}"> Register New User </a></li>
              @endif
             
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

@stop

@section('content')
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">


    <table id="example1" class="table table-bordered table-striped">
      <thead>
        <tr>
			<th >Name</th>
			<th >Email</th>
			<th>Roles & Permissions</th>
			<th>Registration Date</th>
			<th>Status</th>
			<th>Action</th>
        </tr>
      </thead>
      <tbody>
       @foreach($datas as $key => $user)
        <tr>
        	<td >{{ $user->name }}</td>
        	<td >{{ $user->email }}</td>
        	<td >
            
        	</td>
        	<td >{{date('j F, Y',strtotime($user->created_at))}}</td>
        	<td >
        		
        	</td>
        	<td >

        		<a href="/settings/ssers/{{$user->id}}/Edit" title="Edit" target=""> <i class="fa fa-edit fa-2x"></i> </a>
        	</td>
        
        </tr>
       @endforeach
       
      </tbody>
      <tfoot>
			{{ $datas->links() }}
      </tfoot>
    </table>
  </div>
  <!-- /.row -->
  
  </div><!-- /.container-fluid -->
</section>
<!-- /.content -->

@stop