<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VendorPaymentInformation extends Model
{
    use HasFactory;
    protected $fillable = [
        'vendor_id', 'provider_id', 'payment_method_id', 'mobile_acc_no', 'branch_name', 'routing_number', 'account_holder_name', 'account_number'
    ];


    public function payment_method_type()
    {
        return $this->hasOne(SetConfig::class,'id','payment_method_id');
    }

    public function provider_type()
    {
        return $this->hasOne(SetConfig::class,'id','provider_id');
    }

    public function bank_informations()
    {
        return $this->hasOne(BankNameList::class,'id','provider_id');
    }
}


