<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Vehicle extends Model
{
    use HasFactory;
    protected $fillable = [
        'type_id', 'model', 'owner_type', 'brand', 'title', 'vin_sn', 'license', 'validity', 'fuel_type', 'driver_id', 'owner_id', 'color', 'seats', 'vcondition', 'ac', 'price', 'created_at', 'updated_at', 'created_by', 'updated_by', 'status', 'photo', 'bags'
    ];

    public function VehicleDetail()
    {
        return $this->hasOne(VehicleDetail::class,'vehicle_id','id');
    }

    public function VehicleDocument()
    {
        return $this->hasOne(VehicleDocument::class,'vehicle_id','id');
    }

    public function TransporterMain()
    {
        return $this->hasOne(TransporterMain::class,'tID','owner_id');
    }

    public function vehicle_documents_informations(){
        return $this->hasMany(VehicleDocument::class,'vehicle_id','id');
    }

    
}


