<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UploadDocument extends Model
{
    use HasFactory;
    protected $fillable = [
        'doc_type', 'issue_no', 'document_name', 'file_name', 'sort_disc', 'file_path', 'filename', 'created_at', 'updated_at', 'created_by', 'updated_by', 'status', 'file_type', 'file_size', 'ipaddress', 'markas', 'doc_version', 'doc_created', 'doc_published', 'published_by'
    ];

    public function createUser()
    {
        return $this->hasOne(User::class,'id','created_by');
    }
    public function updateUser()
    {
        return $this->hasOne(User::class,'id','updated_by');
    }
    
}
