<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TransactionLog extends Model
{
    use HasFactory;
    public $timestamps = false;
    protected $fillable = [
        'transaction_id', 'comments', 'status', 'created_by', 'created_at'
    ];

    public function user()
    {
        return $this->hasOne(User::class,'id','created_by');
    }
}
