<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TransactionDr extends Model
{
    use HasFactory;
    public $timestamps = false;
    protected $fillable = [
        'trans_id', 'account_id', 'amount', 'disc' 
    ];

    public function dr_account_informations()
    {
        return $this->hasOne(AccChartOfAccountName::class,'account_Name_id','account_id');
    }
    public function transactions()
    {
        return $this->hasOne(transactions::class,'transactionID','trans_id');
    }
    public function DrCostCenter()
    {
        return $this->hasMany(TransactionCostCenter::class,'account_id','account_id')->where('trans_id', $this->trans_id);
    } 


}
