<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TransactionCr extends Model
{
    use HasFactory;
    public $timestamps = false;
    protected $fillable = [
        'trans_id', 'account_id', 'amount', 'disc' 
    ];

    public function cr_account_informations()
    {
        return $this->hasOne(AccChartOfAccountName::class,'account_Name_id','account_id');
    }

    public function transactions()
    {
        return $this->hasOne(transactions::class,'transactionID','trans_id');
    }

}

