<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TrainingSchedule extends Model
{
    use HasFactory;
    // public $timestamps = false;
    protected $fillable = [        
    'training_id', 'session_code', 'type', 'start_date', 'end_date', 'trainer_name', 'training_organization', 'location', 'cost', 'max_enroll', 'created_at', 'updated_at', 'created_by', 'updated_by', 'status', 'evaluation_type'
    ];

    public function training_name(){
        return $this->hasOne(SetTraining::class,'id','training_id');
    }
    public function EnrollCount()
    { 
        return $this->hasMany(TrainingEnrollDetail::class,'schedule_id','id')
        ->selectRaw('count(schedule_id) as total')->where('booked',1);        
    }

}
