<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TrainingCurriculum extends Model
{
    use HasFactory;
    protected $fillable = [        
    'id', 'training_id', 'chapter_name', 'section_id', 'topic', 'duration', 'duration_type_id', 'description', 'content_type', 'file_path','status',
    ];

    public function training_type(){
        return $this->hasOne(SetTraining::class,'id','training_id');
    }

    public function section_type(){
        return $this->hasOne(SetConfig::class,'id','section_id');
    }

    

}
