<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SurveyConfigTemplateQuestion extends Model
{
    use HasFactory;
    public $timestamps = false;
    protected $fillable = [
        'template_id', 'question_id', 'weight',
    ];

    public function question(){
        return $this->hasOne(SurveyConfigQuestion::class,'id','question_id');
    }
    public function answers(){
        return $this->hasMany(SurveyConfigQuestionSet::class,'question_id','question_id');
    }
    public function answerSet()
    {
        return $this->hasManyThrough(
            SurveyConfigAnswer::class, // 3rd tbl
            SurveyConfigQuestionSet::class, // 2nd tbl
            'question_id', // Foreign key on the 2nd table...
            'id', // Foreign key on the 1st main  table...
            'id', // Local key on the 3rd table...
            'answer_id' // Local key on the 2nd table...
        )->orderBy('weight');
    }
}
