<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Survey extends Model
{
    use HasFactory;
    protected $fillable = [
        'template_id', 'type_id', 'name', 'name2', 'company_name', 'site_name', 'location', 'start_date',	'end_date', 'notes', 'created_by', 'updated_by', 'created_at', 'updated_at', 'status'
    ];
    
    public function template(){
        return $this->hasOne(SurveyConfigTemplate::class,'id','template_id');
    }
    public function survey_count(){
        return $this->hasMany(SurveySubmitLog::class,'survey_id','id');
    }
}
