<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SalesQuotation extends Model
{
    use HasFactory;
    protected $fillable = [
    	'ref_number', 'quotation_number', 'customer_id', 'expiration_date', 'attention', 'quotation_date', 'owner_id', 'approver_id', 'vat_total', 'discount_type', 'discount_total', 'net_total', 'terms_notes', 'file_name', 'created_by', 'updated_by', 'created_at', 'updated_at', 'company_id', 'branch_id', 'status'

    ];

        public function customer()
    {
        return $this->hasOne(Customer::class,'id','customer_id');
    }

    public function employee_owner()
    {
        return $this->hasOne(employee::class,'id','owner_id');
    }

    public function employee_approver()
    {
        return $this->hasOne(employee::class,'id','approver_id');
    }

    public function SalesOpportunity()
    {
        return $this->hasOne(SalesOpportunity::class,'id','ref_number');
    }

    public function SalesQuotationItem()
    {
        return $this->hasMany(SalesQuotationItem::class,'quotation_id','id');
    }

    public function SalesOppOrderLog()
    {
        return $this->hasMany(SalesOppOrderLog::class,'quotation_id','id');
    }

}
