<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RequisitionPo extends Model
{
    use HasFactory;
    protected $fillable = [
      'po_no', 'req_id', 'po_date', 'vender_id', 'request_by', 'expected_delivery', 'cost_center', 'terms_notes', 'file_name', 'total_amount', 'bill_id', 'vat_total', 'tax_total', 'company_id', 'branch_id', 'created_at', 'updated_at', 'created_by', 'updated_by', 'status', 'total_items', 'notes', 'approved_by', 'approved_date'
    ];


    public function employee()
    {
      return $this->hasOne(employee::class,'id','request_by');
    }

    public function RequisitionItem()
    {
        return $this->hasMany(RequisitionItem::class,'po_id','id');
    }

    public function RequisitionPoLog()
    {
        return $this->hasMany(RequisitionPoLog::class,'po_id','id');
    }

    public function Vendor()
    {
      return $this->hasOne(Vendor::class,'id','vender_id');
    }

    public function User()
    {
      return $this->hasOne(User::class,'id','created_by');
    }
    
    public function Approved_User()
    {
      return $this->hasOne(User::class,'id','approved_by');
    }

    public function CompanyName()
    {
      return $this->hasOne(CompanyName::class,'id','company_id');
    }

    public function CompanyBranche()
    {
      return $this->hasOne(CompanyBranche::class,'id','branch_id');
    }


}
