<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Requisition extends Model
{
    use HasFactory;
    protected $fillable = [
        'req_no', 'req_date', 'request_by', 'priority', 'expected_delivery', 'category_id', 'items', 'total_amount', 'paid_amount', 'return_amount', 'company_id', 'branch_id', 'file_attach', 'status', 'notes', 'created_at', 'updated_at', 'created_by', 'updated_by', 'approved_by', 'justification'
    ];

    public function employee()
    {
        return $this->hasOne(employee::class,'id','request_by');
    }

    public function RequisitionItem()
    {
        return $this->hasMany(RequisitionItem::class,'req_id','id');
    }

    public function RequisitionItem_qty()
    {
        return $this->hasOne(RequisitionItem::class,'req_id','id');
    }

    public function RequisitionPoLog()
    {
        return $this->hasMany(RequisitionPoLog::class,'requisition_id','id');
    }

    public function RequisitionPoLog_comments()
    {
        return $this->hasOne(RequisitionPoLog::class,'requisition_id','id')->orderBy('requisition_id','DESC');
    }

    public function User()
    {
      return $this->hasOne(User::class,'id','created_by');
    }

    public function Approved_User()
    {
      return $this->hasOne(User::class,'id','updated_by');
    }

    public function CompanyName()
    {
      return $this->hasOne(CompanyName::class,'id','company_id');
    }
    public function CompanyBranche()
    {
      return $this->hasOne(CompanyBranche::class,'id','branch_id');
    }
    
    public function SetConfig()
    {
      return $this->hasOne(SetConfig::class,'id','category_id');
    }

}


