<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MarchantStore extends Model
{
    use HasFactory;
    protected $fillable = [
        'mid', 'store_name', 'contact_name', 'mobile', 'mobile2', 'email', 'city_id', 'zone_id', 'area_id', 'address', 'country_id', 'status'

    ];

    public function city_name()
    {
        return $this->hasOne(AddressCity::class,'id','city_id');
    }

    public function zone_name()
    {
        return $this->hasOne(AddressZone::class,'id','zone_id');
    }
}


