<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Marchant extends Model
{
    use HasFactory;
    protected $fillable = [
        'type', 'business_type', 'name', 'owner_full_name', 'mobile', 'email', 'website', 'fb_page_link', 'kam', 'address_full', 'logo_file', 'comments', 'verification_id_type', 'nid_number', 'font_image', 'back_image', 'pay_method_type', 'provider_id', 'account_number', 'account_name', 'branch_name', 'routing_number', 'acc_holder_name', 'status', 'status_date'
    ];

    public function SetConfig_Informations()
    {
        return $this->hasOne(SetConfig::class,'id','business_type');
    }

    public function merchant_store_informations(){
        return $this->hasMany(MarchantStore::class,'mid','id');
    }

    public function merchant_action_informations(){
        return $this->hasMany(MarchantStatusLog::class,'merchant_id','id');
    }

    public function employee_name()
    {
        return $this->hasOne(employee::class,'id','kam');
    }



}
