<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HrLeaveApplication extends Model
{
    use HasFactory;
    protected $fillable = [        
    'id', 'request_staff_id', 'request_for_id', 'apply_date', 'staff_id', 'leave_type_id', 'day_type', 'start_date', 'end_date', 'backup_staff_id', 'leave_reason', 'leave_address', 'file_name', 'is_recommend', 'recommend_date', 'recommend_comment', 'recommend_user_id', 'is_approved', 'approved_date', 'approved_comment', 'approved_user_id', 'var1'
	];

    public function employeeInfo(){
        return $this->hasOne(employee::class,'id','staff_id');
    }

    public function Leave_Type_name(){
        return $this->hasOne(HrLeaveType::class,'id','leave_type_id');
    }

    public function recommend_user_name(){
        return $this->hasOne(User::class,'id','recommend_user_id');
    }

    public function approved_user_name(){
        return $this->hasOne(User::class,'id','approved_user_id');
    }
    
}
