<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DiagnosticOrder extends Model
{
    use HasFactory;
    protected $fillable = [
    'transaction_id', 'type', 'party_id', 'party_type', 'reference_no','po_number', 'bill_no', 'bill_date', 'terms', 'due_date', 'is_late', 'amount_total','discount_type', 'discount_total', 'vat_total', 'net_total', 'paid_total', 'memo_notes', 'file_name', 'company_id', 'branch_id', 'doctor_id', 'agent_id', 'status'
    ];

    public function Customer()
    {
        return $this->hasOne(Customer::class,'id','party_id');
    }

    public function Doctor()
    {
        return $this->hasOne(Doctor::class,'dID','doctor_id');
    }

    public function OpdPatientsRegistration()
    {
        return $this->hasOne(OpdPatientsRegistration::class,'patient_id','party_id');
    }

}
