<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Customer extends Model
{
    use HasFactory;
    protected $fillable = [
        'type', 'business_type', 'stage', 'customer_type', 'parent_id', 'bill_with', 'designation', 'department', 'photo_path', 'code', 'name', 'kam', 'mobile', 'phone', 'email', 'fax', 'website', 'CreditLimit', 'CreditPeriod', 'opening_balance', 'opening_balance_date', 'is_agent', 'zone', 'area', 'notes', 'chat_account_id', 'created_by', 'updated_by', 'status', 'deactive_date', 'created_at', 'updated_at', 'country_id', 'street', 'city', 'state', 'post_code', 'same_as_address1', 'street2', 'city2', 'state2', 'post_code2', 'country_id2', 'gender', 'age_type','age','date_of_birth','blood_group',     ];

    public function customer_payment_informations()
    {
        return $this->hasMany(CustomerPaymentInformations::class,'customer_id','id');
    }

    public function notes_informations()
    {
        return $this->hasMany(CustomerNotes::class,'customer_id','id');
    }

    public function customer_contact_informations()
    {
        return $this->hasMany(CustomerContact::class,'customer_id','id');
    }

    public function customer_pickup_informations(){
        return $this->hasMany(CustomerPickupAddress::class,'customer_id','id');
    }

    public function customer_delivery_informations(){
        return $this->hasMany(CustomerDeliveryAddress::class,'customer_id','id');
    }

    public function customer_documents_informations(){
        return $this->hasMany(CustomerDocument::class,'customer_id','id');
    }

    public function SetConfig_Informations()
    {
        return $this->hasOne(SetConfig::class,'id','business_type');
    }

    public function employee_informations()
    {
        return $this->hasOne(employee::class,'id','kam');
    }

    

}
