<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AccInvoicePayment extends Model
{
    use HasFactory;
    protected $fillable = [
        'bill_id', 'transaction_id', 'payment_method_id', 'amount', 'instrument_no', 'instrument_date', 'payment_date', 'memo_notes', 'file_name', 'notes', 'created_by', 'updated_by', 'created_at', 'updated_at', 'status', 'payee_id', 'company_id', 'branch_id'
        ];

    public function transactions()
    {
        return $this->hasOne(transactions::class,'transactionID','transaction_id');
    }
    public function AccInvoice()
    {
        return $this->hasOne(AccInvoice::class,'id','bill_id');
    }
}


