<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AccChartOfAccountTypes extends Model
{
    use HasFactory;
     
    protected $primaryKey = 'account_type_ID';
    public $timestamps = false;
    protected $fillable = [
        'root_id', 'account_type_number', 'account_type_name'
        ];

	public function root_account_type()
    {
        return $this->hasOne(AccChartOfAccountRootType::class,'rootID','root_id');
    }
    public function AccountDetailsTypes()
    {
        return $this->hasMany(AccChartOfAccountDetailsTypes::class,'group_id','account_type_ID');
    }

}

