<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AccChartOfAccountDetailsTypes extends Model
{
    use HasFactory;
    protected $primaryKey = 'detail_type_id';
    public $timestamps = false;
    protected $fillable = [
        'dcode', 'detail_type_name', 'details', 'group_id'

        ];

    public function account_type()
    {
        return $this->hasOne(AccChartOfAccountTypes::class,'account_type_ID','group_id');
    }

    public function AccountName()
    {
        return $this->hasMany(AccChartOfAccountName::class,'detail_type_id','detail_type_id');
    }

}