<?php

namespace App\Http\Controllers\eLibery;
use App\Http\Controllers\Controller;
use App\Models\UploadDocument;
use Illuminate\Http\Request;
use Validator;

class UploadDocumentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
      $datas =  UploadDocument::latest('id')->get();
      return view('elibery.UploadList',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       // create show view in route
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

      $file = $request->file('file_name');
      $filesize = $file->getSize();
      //Move Uploaded File

      if(!is_null($file)){
        $nextFileName = date('ymHi').'i'.time().'i'.$request->user()->id;
        $destinationPath = '/euploads/'.date('Y').'/'.date('m').'';
        $uploadres =   $this->fileUpload($request,$nextFileName,$destinationPath); 
      }

      $validator = Validator::make($request->all(), [
      'document_name' => 'required|min:1',
      'issue_no' => 'required|min:1',
      'doc_type' => 'required|min:1',
      ]);
      if ($validator->fails()) {
        return back()->withErrors($validator)->withInput();
      }

      $data = new UploadDocument;
      $data->fill($request->all());
      $data->created_by = $request->user()->id;
      $data->updated_by = $request->user()->id;
      $data->file_path = $destinationPath;
      $data->file_type = $file->getClientOriginalExtension();
      $data->file_size = $filesize;
      $data->file_name = $nextFileName.'.'.$data->file_type;
      $data->ipaddress = $request->ip();
      $data->filename = $destinationPath.'/'.$data->file_name;

      // return $data;
      if ($data->save()) {        
        return back()->with('massage','Document Saved Successfully');
        // return redirect('/hr/emplyee/create')->with('massage','Information Saved Successfully');
      }else return back()->with('error','Document not save....')->withInput();

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\UploadDocument  $uploadDocument
     * @return \Illuminate\Http\Response
     */
    public function show(UploadDocument $uploadDocument)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\UploadDocument  $uploadDocument
     * @return \Illuminate\Http\Response
     */
    public function edit(UploadDocument $uploadDocument)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\UploadDocument  $uploadDocument
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, UploadDocument $uploadDocument)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\UploadDocument  $uploadDocument
     * @return \Illuminate\Http\Response
     */
    public function destroy(UploadDocument $uploadDocument)
    {
        //
    }

    public function fileUpload(Request $request,$fname='',$path='',$fsize=1024)
    { if(empty($fname)) $fname=time();
        // $this->validate($request, [
        //     'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg,zip,doc,docx,pdf|max:'.$fsize.'',
        // ]);
        $image = $request->file('file_name');
        $input['imagename'] = $fname.'.'.$image->getClientOriginalExtension();
        if (empty($path)) {
          $destinationPath = public_path('./euploads/'.date('Y').'/'.date('m').'');
          // $destinationPath = public_path('../euploads/'.date('Y').'/'.date('m').'');
        }else $destinationPath = public_path($path);
        
        $input['destinationPath'] = $destinationPath;
        $image->move($destinationPath, $input['imagename']);
        // dd($input['imagename']);
        return $input;
        return back()->with('success','File Upload successful');
    }
}
