<?php

namespace App\Http\Controllers\Settings;

use App\Http\Controllers\Controller;
use App\Models\TrainingCurriculum;
use Illuminate\Http\Request;
use Illuminate\Http\UploadedFile;
use Validator;
use Illuminate\Support\Facades\Storage;

class TrainingCurriculumController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // $datas =  TrainingCurriculum::oldest('chapter_name')->paginate(50);

        
        $chapter_name = $request->chapter_name;
        $training_id = $request->training_id;
        $curriculum_id = $request->curriculum_id;
        $perPage = $request->has('perPage')?$request->perPage:10;



        $datas = TrainingCurriculum::where('status',1)
        ->when($chapter_name, function($q) use($chapter_name){
          return $q->where('chapter_name',$chapter_name);
        })
        ->when($training_id, function($q) use($training_id){
          return $q->where('training_id',$training_id);
        })
        ->when($curriculum_id, function($q) use($curriculum_id){
          return $q->where('section_id',$curriculum_id);
        })
        ->paginate($perPage);

        return view('settings.SetTrainingCurriculumList',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('settings.SetTrainingCurriculumCreate');

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

      // dd(request()->all());
     $file = $request->file('file_path');
      $filesize = $file->getSize();
      //Move Uploaded File

      if(!is_null($file)){
        $nextFileName = date('ymHi').'i'.time().'i'.$request->user()->id;
        $destinationPath = '/euploads/'.date('Y').'/'.date('m').'';
        $uploadres =   $this->fileUpload($request,$nextFileName,$destinationPath); 
      }


      $validator = Validator::make($request->all(), [
      'training_id' => 'required|min:1',
      ]);
      if ($validator->fails()) {
      return back()->withErrors($validator)->withInput();
      }

      $data = new TrainingCurriculum;
      $data->fill($request->all());
      $data->created_by = $request->user()->id;
      $data->updated_by = $request->user()->id;
      $data->file_path = $destinationPath.'/'.$uploadres['imagename'];

      if ($data->save()) {        
        return back()->with('massage','Information Saved Successfully');
      }else return back()->with('error','Information not save....')->withInput();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\TrainingCurriculum  $trainingCurriculum
     * @return \Illuminate\Http\Response
     */
    public function show(TrainingCurriculum $trainingCurriculum)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\TrainingCurriculum  $trainingCurriculum
     * @return \Illuminate\Http\Response
     */
    public function edit(TrainingCurriculum $trainingCurriculum, $id)
    {
        $data =   TrainingCurriculum::findOrFail($id);
      return view('settings.SetTrainingCurriculumEdit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\TrainingCurriculum  $trainingCurriculum
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, TrainingCurriculum $trainingCurriculum)
    {
      $id = $request->id;

      $data =  TrainingCurriculum::findOrFail($id);
      $data->fill($request->all());
      $request->file('file_path');
      //Move Uploaded File
      if(!is_null($request->file('file_path'))){
        // before new file store delete old file form dir
        $oldFile = $data->file_path;

        if(is_null($oldFile)){
          unlink(public_path($oldFile));
        }
         // if (\File::exists(public_path($oldFile))) \File::deleteDirectory(public_path($oldFile));
        $nextFileName = date('ymHi').'i'.time().'i'.$request->user()->id;
        $destinationPath = '/euploads/'.date('Y').'/'.date('m').'';
        $uploadres =   $this->fileUpload($request,$nextFileName,$destinationPath); 
        $data->file_path = $destinationPath.'/'.$uploadres['imagename'];
      }

      $data->updated_by = $request->user()->id;
      // $data->file_path = $destinationPath.'/'.$uploadres['imagename'];

      $saved = $data->save();
      if (isset($request->url)) {
        return redirect($request->url)->with('massage','Information updated Succesfully');
      }
      return back()->with('massage','Information updated Succesfully');
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\TrainingCurriculum  $trainingCurriculum
     * @return \Illuminate\Http\Response
     */
    public function destroy(TrainingCurriculum $trainingCurriculum)
    {
        //
    }


    public function fileUpload(Request $request,$fname='',$path='',$fsize=1024)
    { if(empty($fname)) $fname=time();
        // $this->validate($request, [
        //     'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg,zip,doc,docx,pdf|max:'.$fsize.'',
        // ]);
        $image = $request->file('file_path');
        $input['imagename'] = $fname.'.'.$image->getClientOriginalExtension();
        if (empty($path)) {
          $destinationPath = public_path('./euploads/'.date('Y').'/'.date('m').'');
          // $destinationPath = public_path('../euploads/'.date('Y').'/'.date('m').'');
        }else $destinationPath = public_path($path);
        
        $input['destinationPath'] = $destinationPath;
        $image->move($destinationPath, $input['imagename']);
        // dd($input['imagename']);
        return $input;
        return back()->with('success','File Upload successful');
    }
}
