<?php

namespace App\Http\Controllers\Settings;
use App\Http\Controllers\Controller;
use App\Models\SetTrainingCategory;
use Illuminate\Http\Request;
use Validator;

class SetTrainingCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        
        $name = $request->name;
        $status = $request->status;
        $perPage = $request->has('perPage')?$request->perPage:10;

        $datas = SetTrainingCategory::when($status, function($q) use($status){
          return $q->where('status',$status);
        })
        ->when($name, function($q) use($name){
          return $q->where('name',$name);
        })
        ->paginate($perPage);

        return view('settings.SetTrainingCategoryList',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('settings.SetTrainingCategoryCreate');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
      $validator = Validator::make($request->all(), [
      'name' => 'required|min:1',
      ]);
      if ($validator->fails()) {
      return back()->withErrors($validator)->withInput();
      }

      $data = new SetTrainingCategory;
      $data->fill($request->all());
      // $data->created_by = $request->user()->id;
      // $data->updated_by = $request->user()->id;
      if ($data->save()) {        
        return back()->with('massage','Information Saved Successfully');
      }else return back()->with('error','Information not save....')->withInput();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\SetTrainingCategory  $setTrainingCategory
     * @return \Illuminate\Http\Response
     */
    public function show(SetTrainingCategory $setTrainingCategory)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\SetTrainingCategory  $setTrainingCategory
     * @return \Illuminate\Http\Response
     */
    public function edit(SetTrainingCategory $setTrainingCategory, $id)
    {
        $data =   SetTrainingCategory::findOrFail($id);
      return view('settings.SetTrainingCategoryEdit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\SetTrainingCategory  $setTrainingCategory
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, SetTrainingCategory $setTrainingCategory)
    {
        $id = $request->id;
      $data =  SetTrainingCategory::findOrFail($id);
      $data->fill($request->all());
      
      // $data->updated_by = $request->user()->id;
      $saved = $data->save();
      if (isset($request->url)) {
        return redirect($request->url)->with('massage','Information updated Succesfully');
      }
      return back()->with('massage','Information updated Succesfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\SetTrainingCategory  $setTrainingCategory
     * @return \Illuminate\Http\Response
     */
    public function destroy(SetTrainingCategory $setTrainingCategory)
    {
        //
    }
}
