<?php

namespace App\Http\Controllers\Settings;
use App\Http\Controllers\Controller;

use App\Models\ProductUnit;
use Illuminate\Http\Request;
use Validator;

class ProductUnitController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
      $name = $request->name;
      $status = $request->status;
      $perPage = $request->has('perPage')?$request->perPage:10;

      $datas = ProductUnit::when($name, function($q) use($name){
        return $q->where('name','like',"%{$name}%");
      })
      ->when($status, function($q) use($status){
        return $q->where('status',$status);
      })
      ->when(isset($status) && ($status==0), function($q) use($status){
        return $q->where('status',$status);
      })
      ->orderby('id','desc')
      ->paginate($perPage);

      return view('settings.Inventory.ProductUnitList',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
      $validator = Validator::make($request->all(), [
      'name' => 'required|min:1',
      ]);
      if ($validator->fails()) {
      return back()->withErrors($validator)->withInput();
      }

      $data = new ProductUnit;
      $data->fill($request->all());
      if ($data->save()) {        
        return back()->with('massage','Information Saved Successfully');
      }else return back()->with('error','Information not save....')->withInput();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ProductUnit  $productUnit
     * @return \Illuminate\Http\Response
     */
    public function show(ProductUnit $productUnit)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\ProductUnit  $productUnit
     * @return \Illuminate\Http\Response
     */
    public function edit(ProductUnit $productUnit, $id)
    {
        $data =   ProductUnit::findOrFail($id);
      return view('settings.Inventory.ProductUnitEdit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\ProductUnit  $productUnit
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ProductUnit $productUnit)
    {
      $id = $request->id;
      $data =  ProductUnit::findOrFail($id);
      $data->fill($request->all());
      
      $saved = $data->save();
      if (isset($request->url)) {
        return redirect($request->url)->with('massage','Information updated Succesfully');
      }
      return back()->with('massage','Information updated Succesfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ProductUnit  $productUnit
     * @return \Illuminate\Http\Response
     */
    public function destroy(ProductUnit $productUnit)
    {
        //
    }
}
