<?php

namespace App\Http\Controllers\Settings;
use App\Http\Controllers\Controller;

use App\Models\ProductCategorie;
use Illuminate\Http\Request;
use Validator;



class ProductCategorieController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
      $category_name = $request->category_name;
      $parent_cat_id = $request->parent_cat_id;
      $status = $request->status;
      $perPage = $request->has('perPage')?$request->perPage:10;

      $datas = ProductCategorie::when($category_name, function($q) use($category_name){
        return $q->where('catName','like',"%{$category_name}%");
      })
      ->when($parent_cat_id, function($q) use($parent_cat_id){
        return $q->where('parentID',$parent_cat_id);
      })
      ->when($status, function($q) use($status){
        return $q->where('status',$status);
      })
      ->when(isset($status) && ($status==0), function($q) use($status){
        return $q->where('status',$status);
      })
      ->orderby('catID','desc')
      ->paginate($perPage);
      return view('settings.Inventory.ProductCategoryList',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
      $validator = Validator::make($request->all(), [
      'catName' => 'required|min:1',
      ]);
      if ($validator->fails()) {
      return back()->withErrors($validator)->withInput();
      }

      $data = new ProductCategorie;
      $data->fill($request->all());
      if ($data->save()) {        
        return back()->with('massage','Information Saved Successfully');
      }else return back()->with('error','Information not save....')->withInput();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\ProductCategorie  $productCategorie
     * @return \Illuminate\Http\Response
     */
    public function show(ProductCategorie $productCategorie)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\ProductCategorie  $productCategorie
     * @return \Illuminate\Http\Response
     */
    public function edit(ProductCategorie $productCategorie, $id)
    {
        $data =   ProductCategorie::findOrFail($id);
      return view('settings.Inventory.ProductCategoryEdit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\ProductCategorie  $productCategorie
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ProductCategorie $productCategorie)
    {
      $id = $request->id;
      $data =  ProductCategorie::findOrFail($id);
      $data->fill($request->all());
      
      $data->updateBy = $request->user()->id;
      $saved = $data->save();
      if (isset($request->url)) {
        return redirect($request->url)->with('massage','Information updated Succesfully');
      }
      return back()->with('massage','Information updated Succesfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ProductCategorie  $productCategorie
     * @return \Illuminate\Http\Response
     */
    public function destroy(ProductCategorie $productCategorie)
    {
        //
    }
}
