<?php

namespace App\Http\Controllers\Settings;
use App\Http\Controllers\Controller;
use App\Models\BankNameList;


use Illuminate\Http\Request;
use Validator;

class BankNameListController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $bankName = $request->bankName;
        $perPage = $request->has('perPage')?$request->perPage:10;

        

        $datas = BankNameList::where('status',1)
        ->when($bankName, function($q) use($bankName){
          return $q->where('bankName',$bankName);
        })
        ->paginate($perPage);

        return view('settings.SetProviderNameList',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('settings.SetProviderNameCreate');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
      'bankName' => 'required|min:1',
      ]);
      if ($validator->fails()) {
      return back()->withErrors($validator)->withInput();
      }

      $data = new BankNameList;
      $data->fill($request->all());
      
      if ($data->save()) {        
        return back()->with('massage','Information Saved Successfully');
      }else return back()->with('error','Information not save....')->withInput();

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(BankNameList $bankNameList, $id)
    {
        $data =   BankNameList::findOrFail($id);
      return view('settings.SetProviderNameEdit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, BankNameList $bankNameList)
    {
      $id = $request->id;
      $data =  BankNameList::findOrFail($id);
      $data->fill($request->all());
      
      
      $saved = $data->save();
      if (isset($request->url)) {
        return redirect($request->url)->with('massage','Information updated Succesfully');
      }
      return back()->with('massage','Information updated Succesfully');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
