<?php

namespace App\Http\Controllers\Settings;
use App\Http\Controllers\Controller;

use App\Models\AddressArea;
use Illuminate\Http\Request;

use Validator;

class AddressAreaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
      'name' => 'required|min:1',
      ]);
      if ($validator->fails()) {
      return back()->withErrors($validator)->withInput();
      }

      $data = new AddressArea;
      $data->fill($request->all());
      
      if ($data->save()) {        
        return back()->with('massage','Information Saved Successfully');
      }else return back()->with('error','Information not save....')->withInput();

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\AddressArea  $addressArea
     * @return \Illuminate\Http\Response
     */
    public function show(AddressArea $addressArea)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\AddressArea  $addressArea
     * @return \Illuminate\Http\Response
     */
    public function edit(AddressArea $addressArea)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\AddressArea  $addressArea
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, AddressArea $addressArea)
    {
      $id = $request->id;
      $data =  AddressArea::findOrFail($id);
      $data->fill($request->all());
      
      
      $saved = $data->save();
      
      if ($saved) {        
        return back()->with('massage','Information Updated Successfully');
      }else return back()->with('error','Information not updated....')->withInput();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\AddressArea  $addressArea
     * @return \Illuminate\Http\Response
     */
    public function destroy(AddressArea $addressArea)
    {
        //
    }
}
