<?php

namespace App\Http\Controllers\Settings;
use App\Http\Controllers\Controller;

use App\Models\AccCostCenter;
use Illuminate\Http\Request;

use Validator;

class AccCostCenterController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index(Request $request,$transType=null,$rtn_data=0)
    {
        $perPage = $request->has('plimit')?$request->input('plimit'):50;
        $name = $request->input('name');
        $parent_id = $request->input('parent_id');
        $status = $request->input('status');
    
        $datas = AccCostCenter::when($name, function($q) use($name){
          return $q->where('name','like',"%{$name}%");
        })
        ->when($parent_id, function($q) use($parent_id){
          return $q->where('parent_id',$parent_id);
        })
        ->when($status, function($q) use($status){
          return $q->where('status',$status);
        })
        ->when(isset($status) && ($status==0), function($q) use($status){
          return $q->where('status',$status);
        })
        ->paginate($perPage);

        if($rtn_data>0) return $datas;
        return view('settings.SetCostCenterList',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
      $validator = Validator::make($request->all(), [
      'name' => 'required|min:1',
      ]);
      if ($validator->fails()) {
      return back()->withErrors($validator)->withInput();
      }

      $data = new AccCostCenter;
      $data->fill($request->all());

      $data->created_by = $request->user()->id;
      $data->updated_by = $request->user()->id;
      
      // return $data;

      if ($data->save()) {        
        return back()->with('massage','Information Saved Successfully');
      }else return back()->with('error','Information not save....')->withInput();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\AccCostCenter  $accCostCenter
     * @return \Illuminate\Http\Response
     */
    public function show(AccCostCenter $accCostCenter)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\AccCostCenter  $accCostCenter
     * @return \Illuminate\Http\Response
     */
    public function edit(AccCostCenter $accCostCenter, $id)
    {
      $data = AccCostCenter::findOrFail($id);
      return view('settings.SetCostCenterEdit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\AccCostCenter  $accCostCenter
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, AccCostCenter $accCostCenter)
    {
      $id = $request->id;
      $data =  AccCostCenter::findOrFail($id);
      $data->fill($request->all());

      $data->updated_by = $request->user()->id;
           
      
      $saved = $data->save();
      if (isset($request->url)) {
        return redirect($request->url)->with('massage','Information updated Succesfully');
      }
      return back()->with('massage','Information updated Succesfully');
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\AccCostCenter  $accCostCenter
     * @return \Illuminate\Http\Response
     */
    public function destroy(AccCostCenter $accCostCenter)
    {
        //
    }
}
