<?php

namespace App\Http\Controllers\Settings;
use App\Http\Controllers\Controller;

use App\Models\AccChartOfAccountTypes;
use App\Models\AccChartOfAccountRootType;
use Illuminate\Http\Request;

use Validator;

class AccChartOfAccountTypesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
      'account_type_name' => 'required|min:1',
      ]);
      if ($validator->fails()) {
      return back()->withErrors($validator)->withInput();
      }

      $data = new AccChartOfAccountTypes;
      $data->fill($request->all());

      $data2 =  AccChartOfAccountRootType::findOrFail($request->root_id);

      $data->account_type_number = $data2->rootID.$request->account_type_number;

      
      if ($data->save()) {        
        return redirect($request->url.'?tab='.$request->tab)->with('massage','Information Saved Successfully');
      }else return back()->with('error','Information not save....')->withInput();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\AccChartOfAccountTypes  $accChartOfAccountTypes
     * @return \Illuminate\Http\Response
     */
    public function show(AccChartOfAccountTypes $accChartOfAccountTypes)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\AccChartOfAccountTypes  $accChartOfAccountTypes
     * @return \Illuminate\Http\Response
     */
    public function edit(AccChartOfAccountTypes $accChartOfAccountTypes)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\AccChartOfAccountTypes  $accChartOfAccountTypes
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, AccChartOfAccountTypes $accChartOfAccountTypes)
    {
    
      $id = $request->id;
      $data =  AccChartOfAccountTypes::findOrFail($id);
      $data->fill($request->all());

      $data2 =  AccChartOfAccountRootType::findOrFail($request->root_id);

      $data->account_type_number = $data2->rootID.$request->account_type_number;
      
      
      $saved = $data->save();
      
      if ($saved) {        
        return redirect($request->url.'?tab='.$request->tab)->with('massage','Information Updated Successfully');
      }else return back()->with('error','Information not updated....')->withInput();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\AccChartOfAccountTypes  $accChartOfAccountTypes
     * @return \Illuminate\Http\Response
     */
    public function destroy(AccChartOfAccountTypes $accChartOfAccountTypes)
    {
        //
    }
}
