<?php

namespace App\Http\Controllers\Settings;
use App\Http\Controllers\Controller;

use App\Models\AccChartOfAccountDetailsTypes;
use Illuminate\Http\Request;
use App\Models\AccChartOfAccountTypes;
use Validator;

class AccChartOfAccountDetailsTypesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
      'detail_type_name' => 'required|min:1',
      ]);
      if ($validator->fails()) {
      return back()->withErrors($validator)->withInput();
      }

      $data = new AccChartOfAccountDetailsTypes;
      $data->fill($request->all());

      $data2 =  AccChartOfAccountTypes::findOrFail($request->group_id);

      $data->dcode = $data2->account_type_number.$request->dcode;
      
      if ($data->save()) {        
        return redirect($request->url.'?tab='.$request->tab)->with('massage','Information Saved Successfully');
      }else return back()->with('error','Information not save....')->withInput();

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\AccChartOfAccountDetailsTypes  $accChartOfAccountDetailsTypes
     * @return \Illuminate\Http\Response
     */
    public function show(AccChartOfAccountDetailsTypes $accChartOfAccountDetailsTypes)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\AccChartOfAccountDetailsTypes  $accChartOfAccountDetailsTypes
     * @return \Illuminate\Http\Response
     */
    public function edit(AccChartOfAccountDetailsTypes $accChartOfAccountDetailsTypes)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\AccChartOfAccountDetailsTypes  $accChartOfAccountDetailsTypes
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, AccChartOfAccountDetailsTypes $accChartOfAccountDetailsTypes)
    {
      $id = $request->id;
      $data =  AccChartOfAccountDetailsTypes::findOrFail($id);
      $data->fill($request->all());

      $data2 =  AccChartOfAccountTypes::findOrFail($request->group_id);

      $data->dcode = $data2->account_type_number.$request->dcode;
      
      
      $saved = $data->save();

      if ($saved) {        
        return redirect($request->url.'?tab='.$request->tab)->with('massage','Information Updated Successfully');
      }else return back()->with('error','Information not updated....')->withInput();


    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\AccChartOfAccountDetailsTypes  $accChartOfAccountDetailsTypes
     * @return \Illuminate\Http\Response
     */
    public function destroy(AccChartOfAccountDetailsTypes $accChartOfAccountDetailsTypes)
    {
        //
    }
}
